/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.teamapps.application.api.state.ReplicatedList;
import org.teamapps.application.api.state.ReplicatedProperty;
import org.teamapps.cluster.state.LocalState;
import org.teamapps.cluster.state.ReplicatedState;
import org.teamapps.cluster.state.ReplicatedStateHandler;
import org.teamapps.cluster.state.StateUpdate;
import org.teamapps.cluster.state.StateUpdateMessage;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelCollection;

public class ReplicatedUxState
implements ReplicatedStateHandler {
    private ReplicatedState replicatedState;
    private final Map<String, ReplicatedList<? extends MessageObject>> distributedListByName = new HashMap<String, ReplicatedList<? extends MessageObject>>();
    private final Map<String, ReplicatedProperty<? extends MessageObject>> distributedStateByName = new HashMap<String, ReplicatedProperty<? extends MessageObject>>();
    private final List<StateUpdateMessage> preparedUpdates = new ArrayList<StateUpdateMessage>();

    public void setReplicatedState(ReplicatedState replicatedState) {
        this.replicatedState = replicatedState;
    }

    public <TYPE extends MessageObject> ReplicatedList<TYPE> createList(String name, String modelUuid, Function<TYPE, String> typeToIdFunction, ModelCollection modelCollection) {
        ReplicatedList<TYPE> replicatedList = new ReplicatedList<TYPE>(this.replicatedState, name, modelUuid, typeToIdFunction, modelCollection, this.preparedUpdates);
        this.distributedListByName.put(name, replicatedList);
        return replicatedList;
    }

    public <TYPE extends MessageObject> ReplicatedProperty<TYPE> createState(String name, String modelUuid, ModelCollection modelCollection) {
        ReplicatedProperty replicatedProperty = new ReplicatedProperty(this.replicatedState, name, modelUuid, modelCollection, this.preparedUpdates);
        this.distributedStateByName.put(name, replicatedProperty);
        return replicatedProperty;
    }

    public void executePreparedUpdates() {
        this.replicatedState.executeStateMachineUpdate(new StateUpdate(this.replicatedState.getName(), this.preparedUpdates));
        this.preparedUpdates.clear();
    }

    private ReplicatedList<? extends MessageObject> getDistributedList(String name) {
        return this.distributedListByName.get(name);
    }

    private ReplicatedProperty<? extends MessageObject> getDistributedState(String name) {
        return this.distributedStateByName.get(name);
    }

    public static void main(String[] args) {
        ReplicatedUxState replicatedUxState = new ReplicatedUxState();
        replicatedUxState.setReplicatedState((ReplicatedState)new LocalState("testMachine", (ReplicatedStateHandler)replicatedUxState));
    }

    public void handleStateUpdated(String stateId, MessageObject state) {
        ReplicatedProperty<? extends MessageObject> replicatedProperty = this.getDistributedState(stateId);
        if (replicatedProperty != null) {
            replicatedProperty.handleSetState(state);
        }
    }

    public void handleEntryAdded(String list, MessageObject message) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getDistributedList(list);
        if (replicatedList != null) {
            replicatedList.handleEntryAdded(message);
        }
    }

    public void handleEntryRemoved(String list, MessageObject message) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getDistributedList(list);
        if (replicatedList != null) {
            replicatedList.handleEntryRemoved(message);
        }
    }

    public void handleEntryUpdated(String list, MessageObject currentState, MessageObject previousState) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getDistributedList(list);
        if (replicatedList != null) {
            replicatedList.handleEntryUpdated(currentState);
        }
    }

    public void handleAllEntriesRemoved(String list) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getDistributedList(list);
        if (replicatedList != null) {
            replicatedList.handleAllEntriesRemoved();
        }
    }

    public void handleFireAndForget(String list, MessageObject message) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getDistributedList(list);
        if (replicatedList != null) {
            replicatedList.handleFireAndForget(message);
        }
    }

    public void handleStateMachineRemoved() {
    }
}

