/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.slf4j.event.Level;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.api.application.entity.EntityUpdate;
import org.teamapps.application.api.application.perspective.ApplicationPerspective;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.desktop.ApplicationDesktop;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.application.api.organization.UserRoleType;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.RoleAssignmentDelegatedCustomPrivilegeGroup;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.ui.UiComponentFactory;
import org.teamapps.application.api.user.SessionUser;
import org.teamapps.application.server.DevApplicationRolePrivilegeProvider;
import org.teamapps.application.server.DevSessionUser;
import org.teamapps.application.server.DevUiComponentFactory;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.session.SessionContext;

public class DevApplicationData
implements ApplicationInstanceData {
    private final ApplicationRole applicationRole;
    private final SessionContext context;
    private final Locale locale;
    private final ApplicationLocalizationProvider localizationProvider;
    private final BaseApplicationBuilder applicationBuilder;
    private final List<OrganizationUnitView> organizationUnitViews;
    private final DocumentConverter documentConverter;
    private final ResponsiveApplication responsiveApplication;
    private final SessionUser sessionUser;
    private ApplicationPrivilegeProvider applicationPrivilegeProvider;
    private UiComponentFactory uiComponentFactory;

    public DevApplicationData(ApplicationRole applicationRole, SessionContext context, Locale locale, ApplicationLocalizationProvider localizationProvider, BaseApplicationBuilder applicationBuilder, List<OrganizationUnitView> organizationUnitViews, DocumentConverter documentConverter, ResponsiveApplication responsiveApplication) {
        this.applicationRole = applicationRole;
        this.context = context;
        this.locale = locale;
        this.localizationProvider = localizationProvider;
        this.applicationBuilder = applicationBuilder;
        this.organizationUnitViews = organizationUnitViews;
        this.documentConverter = documentConverter;
        this.responsiveApplication = responsiveApplication;
        this.sessionUser = new DevSessionUser(context, locale);
        this.applicationPrivilegeProvider = applicationRole != null ? new DevApplicationRolePrivilegeProvider(applicationRole, new HashSet<OrganizationUnitView>(organizationUnitViews)) : null;
        this.uiComponentFactory = new DevUiComponentFactory(this);
    }

    @Override
    public SessionUser getUser() {
        return this.sessionUser;
    }

    @Override
    public OrganizationFieldView getOrganizationField() {
        return null;
    }

    @Override
    public int getManagedApplicationId() {
        return 0;
    }

    @Override
    public DocumentConverter getDocumentConverter() {
        return this.documentConverter;
    }

    @Override
    public MultiProgressDisplay getMultiProgressDisplay() {
        return this.responsiveApplication.getMultiProgressDisplay();
    }

    @Override
    public void showPerspective(Perspective perspective) {
        this.responsiveApplication.showPerspective(perspective);
    }

    @Override
    public ApplicationPerspective showApplicationPerspective(String perspectiveName) {
        return null;
    }

    @Override
    public ApplicationDesktop createApplicationDesktop() {
        return null;
    }

    @Override
    public UiComponentFactory getComponentFactory() {
        return this.uiComponentFactory;
    }

    @Override
    public boolean isDarkTheme() {
        return false;
    }

    @Override
    public ApplicationConfig<?> getApplicationConfig() {
        return this.applicationBuilder.getApplicationConfig();
    }

    @Override
    public void writeActivityLog(Level level, String eventTitle, String eventData) {
        System.out.println("User activity: " + eventTitle + ", " + eventData);
    }

    @Override
    public void writeExceptionLog(Level level, String title, Throwable throwable) {
        System.out.println("Exception: " + title + ", " + throwable.getMessage());
    }

    @Override
    public Integer getOrganizationUserWithRole(OrganizationUnitView orgUnit, UserRoleType userRoleType) {
        return 1;
    }

    @Override
    public String getOrganizationUserNameWithRole(OrganizationUnitView orgUnit, UserRoleType userRoleType, boolean lastNameFirst) {
        return lastNameFirst ? "Doe, John" : "John Doe";
    }

    @Override
    public List<Integer> getOrganizationUsersWithRole(OrganizationUnitView orgUnit, UserRoleType userRoleType) {
        return Collections.singletonList(1);
    }

    @Override
    public <ENTITY> void registerEntity(EntityBuilder<ENTITY> entityBuilder, Consumer<EntityUpdate<ENTITY>> listener) {
    }

    @Override
    public boolean isAllowed(SimplePrivilege simplePrivilege) {
        return this.applicationPrivilegeProvider == null || this.applicationPrivilegeProvider.isAllowed(simplePrivilege);
    }

    @Override
    public boolean isAllowed(SimpleOrganizationalPrivilege group, OrganizationUnitView organizationUnitView) {
        return this.applicationPrivilegeProvider == null || this.applicationPrivilegeProvider.isAllowed(group, organizationUnitView);
    }

    @Override
    public boolean isAllowed(SimpleCustomObjectPrivilege group, PrivilegeObject privilegeObject) {
        return this.applicationPrivilegeProvider == null || this.applicationPrivilegeProvider.isAllowed(group, privilegeObject);
    }

    @Override
    public boolean isAllowed(StandardPrivilegeGroup group, Privilege privilege) {
        return this.applicationPrivilegeProvider == null || this.applicationPrivilegeProvider.isAllowed(group, privilege);
    }

    @Override
    public boolean isAllowed(OrganizationalPrivilegeGroup group, Privilege privilege, OrganizationUnitView organizationUnitView) {
        return this.applicationPrivilegeProvider == null || this.applicationPrivilegeProvider.isAllowed(group, privilege, organizationUnitView);
    }

    @Override
    public boolean isAllowed(CustomObjectPrivilegeGroup group, Privilege privilege, PrivilegeObject privilegeObject) {
        return this.applicationPrivilegeProvider == null || this.applicationPrivilegeProvider.isAllowed(group, privilege, privilegeObject);
    }

    @Override
    public boolean isAllowed(RoleAssignmentDelegatedCustomPrivilegeGroup group, Privilege privilege, PrivilegeObject privilegeObject) {
        return this.applicationPrivilegeProvider == null || this.applicationPrivilegeProvider.isAllowed(group, privilege, privilegeObject);
    }

    @Override
    public List<OrganizationUnitView> getAllowedUnits(SimpleOrganizationalPrivilege simplePrivilege) {
        return this.applicationPrivilegeProvider != null ? this.applicationPrivilegeProvider.getAllowedUnits(simplePrivilege) : this.organizationUnitViews;
    }

    @Override
    public List<OrganizationUnitView> getAllowedUnits(OrganizationalPrivilegeGroup group, Privilege privilege) {
        return this.applicationPrivilegeProvider != null ? this.applicationPrivilegeProvider.getAllowedUnits(group, privilege) : this.organizationUnitViews;
    }

    @Override
    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simplePrivilege) {
        return this.applicationPrivilegeProvider != null ? this.applicationPrivilegeProvider.getAllowedPrivilegeObjects(simplePrivilege) : simplePrivilege.getPrivilegeObjectsSupplier().get();
    }

    @Override
    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup group, Privilege privilege) {
        return this.applicationPrivilegeProvider != null ? this.applicationPrivilegeProvider.getAllowedPrivilegeObjects(group, privilege) : group.getPrivilegeObjectsSupplier().get();
    }

    @Override
    public List<PrivilegeObject> getAllowedPrivilegeObjects(RoleAssignmentDelegatedCustomPrivilegeGroup group, Privilege privilege) {
        return this.applicationPrivilegeProvider != null ? this.applicationPrivilegeProvider.getAllowedPrivilegeObjects(group, privilege) : Collections.emptyList();
    }

    @Override
    public String getLocalized(String key, Object ... parameters) {
        return this.localizationProvider.getLocalized(key, parameters);
    }

    @Override
    public String getLocalized(String key, List<String> languagePriorityOrder, Object ... parameters) {
        return this.localizationProvider.getLocalized(key, languagePriorityOrder, parameters);
    }

    @Override
    public String getLocalized(TranslatableText translatableText) {
        return this.localizationProvider.getLocalized(translatableText);
    }
}

