/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.state;

import java.util.List;
import org.teamapps.cluster.state.ReplicatedState;
import org.teamapps.cluster.state.StateUpdateMessage;
import org.teamapps.event.Event;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.ModelCollection;
import org.teamapps.protocol.schema.PojoObjectDecoder;

public class ReplicatedProperty<TYPE extends MessageObject> {
    private final ReplicatedState distributedStateMachine;
    private final String stateName;
    private final String modelUuid;
    private final ModelCollection modelCollection;
    private final List<StateUpdateMessage> preparedUpdates;
    private final PojoObjectDecoder<TYPE> messageDecoder;
    public Event<TYPE> onStateChanged = new Event();

    protected ReplicatedProperty(ReplicatedState distributedStateMachine, String stateName, String modelUuid, ModelCollection modelCollection, List<StateUpdateMessage> preparedUpdates) {
        this.distributedStateMachine = distributedStateMachine;
        this.stateName = stateName;
        this.modelUuid = modelUuid;
        this.modelCollection = modelCollection;
        this.preparedUpdates = preparedUpdates;
        this.messageDecoder = modelCollection.getMessageDecoder(modelUuid);
    }

    public void prepareUpdateState(TYPE state) {
        this.preparedUpdates.add(this.distributedStateMachine.prepareSetState(this.stateName, state));
    }

    public void setState(TYPE state) {
        this.distributedStateMachine.setProperty(this.stateName, state);
    }

    public TYPE getProperty() {
        return this.remap(this.distributedStateMachine.getProperty(this.stateName));
    }

    protected void handleSetState(MessageObject state) {
        this.onStateChanged.fire(this.remap(state));
    }

    protected TYPE remap(MessageObject message) {
        return (TYPE)(message != null ? this.messageDecoder.remap(message) : null);
    }
}

