/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import org.teamapps.application.api.application.BaseApplicationBuilder;
import org.teamapps.application.server.ApplicationLoader;
import org.teamapps.application.server.ApplicationServer;
import org.teamapps.application.server.SessionHandler;
import org.teamapps.config.TeamAppsConfiguration;

public class EmbeddedApplicationServer {
    public static void startServerWithApplication(String login, String password, boolean darkTheme, BaseApplicationBuilder applicationBuilder) throws Exception {
        EmbeddedApplicationServer.startServerWithApplication(null, login, password, darkTheme, applicationBuilder);
    }

    public static void startServerWithApplication(InputStream baseDataInputStream, String login, String password, boolean darkTheme, BaseApplicationBuilder applicationBuilder) throws Exception {
        File basePath = new File("./server-data");
        EmbeddedApplicationServer.startServerWithApplication(baseDataInputStream, login, password, darkTheme, applicationBuilder, basePath, 8080);
    }

    public static void startServerWithApplication(InputStream baseDataInputStream, String login, String password, boolean darkTheme, BaseApplicationBuilder applicationBuilder, File basePath, int port) throws Exception {
        EmbeddedApplicationServer.startServerWithApplications(baseDataInputStream, login, password, darkTheme, basePath, port, applicationBuilder);
    }

    public static void startServerWithApplications(InputStream baseDataInputStream, String login, String password, boolean darkTheme, File basePath, int port, BaseApplicationBuilder ... applicationBuilders) throws Exception {
        EmbeddedApplicationServer.startServerWithApplications(baseDataInputStream, login, password, darkTheme, basePath, port, new TeamAppsConfiguration(), applicationBuilders);
    }

    public static void startServerWithApplications(InputStream baseDataInputStream, String login, String password, boolean darkTheme, File basePath, int port, TeamAppsConfiguration teamAppsConfiguration, BaseApplicationBuilder ... applicationBuilders) throws Exception {
        basePath.mkdir();
        ApplicationServer applicationServer = new ApplicationServer(basePath, teamAppsConfiguration, port);
        URL resource = EmbeddedApplicationServer.class.getResource("/org/teamapps/application/api/emdedded/embedded-system.jar");
        SessionHandler sessionHandler = applicationServer.updateSessionHandler(resource);
        applicationServer.start();
        ApplicationLoader applicationLoader = (ApplicationLoader)sessionHandler;
        if (baseDataInputStream != null) {
            applicationLoader.createInitialData(baseDataInputStream);
        }
        if (login != null) {
            applicationLoader.createInitialLogin(login, password, darkTheme);
        }
        for (BaseApplicationBuilder builder : applicationBuilders) {
            applicationLoader.installAndLoadApplication(builder);
        }
    }
}

