/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.teamapps.application.api.state.ReplicatedList;
import org.teamapps.application.api.state.ReplicatedProperty;
import org.teamapps.cluster.state.ReplicatedState;
import org.teamapps.cluster.state.ReplicatedStateHandler;
import org.teamapps.cluster.state.ReplicatedStateTransactionRule;
import org.teamapps.cluster.state.StateUpdate;
import org.teamapps.cluster.state.StateUpdateMessage;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.PojoObjectDecoder;

public class ReplicatedStateMachine
implements ReplicatedStateHandler {
    private final ReplicatedState replicatedState;
    private final Map<String, ReplicatedList<? extends MessageObject>> distributedListByName = new HashMap<String, ReplicatedList<? extends MessageObject>>();
    private final Map<String, ReplicatedProperty<? extends MessageObject>> distributedStateByName = new HashMap<String, ReplicatedProperty<? extends MessageObject>>();
    private final List<StateUpdateMessage> preparedUpdates = new ArrayList<StateUpdateMessage>();
    private final List<ReplicatedStateTransactionRule> transactionRules = new ArrayList<ReplicatedStateTransactionRule>();

    public ReplicatedStateMachine(ReplicatedState replicatedState) {
        this.replicatedState = replicatedState;
    }

    public <TYPE extends MessageObject> ReplicatedList<TYPE> createList(String name, PojoObjectDecoder<TYPE> messageDecoder, Function<TYPE, String> typeToIdFunction) {
        ReplicatedList<TYPE> replicatedList = new ReplicatedList<TYPE>(this.replicatedState, name, messageDecoder, typeToIdFunction, this.preparedUpdates, this.transactionRules);
        this.distributedListByName.put(name, replicatedList);
        return replicatedList;
    }

    public <TYPE extends MessageObject> ReplicatedProperty<TYPE> createState(String name, PojoObjectDecoder<TYPE> messageDecoder) {
        ReplicatedProperty<TYPE> replicatedProperty = new ReplicatedProperty<TYPE>(this.replicatedState, name, messageDecoder, this.preparedUpdates);
        this.distributedStateByName.put(name, replicatedProperty);
        return replicatedProperty;
    }

    public void executePreparedUpdates() {
        this.replicatedState.executeStateMachineUpdate(new StateUpdate(this.replicatedState.getName(), this.preparedUpdates, this.transactionRules));
        this.preparedUpdates.clear();
        this.transactionRules.clear();
    }

    private ReplicatedList<? extends MessageObject> getReplicatedList(String name) {
        return this.distributedListByName.get(name);
    }

    private ReplicatedProperty<? extends MessageObject> getReplicatedState(String name) {
        return this.distributedStateByName.get(name);
    }

    public void handleStateUpdated(String stateId, MessageObject state) {
        ReplicatedProperty<? extends MessageObject> replicatedProperty = this.getReplicatedState(stateId);
        if (replicatedProperty != null) {
            replicatedProperty.handleSetState(state);
        }
    }

    public void handleEntryAdded(String list, MessageObject message) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getReplicatedList(list);
        if (replicatedList != null) {
            replicatedList.handleEntryAdded(message);
        }
    }

    public void handleEntryRemoved(String list, MessageObject message) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getReplicatedList(list);
        if (replicatedList != null) {
            replicatedList.handleEntryRemoved(message);
        }
    }

    public void handleEntryUpdated(String list, MessageObject currentState, MessageObject previousState) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getReplicatedList(list);
        if (replicatedList != null) {
            replicatedList.handleEntryUpdated(currentState);
        }
    }

    public void handleAllEntriesRemoved(String list) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getReplicatedList(list);
        if (replicatedList != null) {
            replicatedList.handleAllEntriesRemoved();
        }
    }

    public void handleFireAndForget(String list, MessageObject message) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getReplicatedList(list);
        if (replicatedList != null) {
            replicatedList.handleFireAndForget(message);
        }
    }

    public void handleStateMachineRemoved() {
    }
}

