/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.AbstractApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.event.Event;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;

public abstract class AbstractLazyRenderingApplicationView
extends AbstractApplicationView {
    public final Event<Void> onViewRedrawRequired = new Event();
    private final TwoWayBindableValue<Boolean> visible = TwoWayBindableValue.create((Object)true);
    private final View view;
    private final View targetView;
    private boolean created;
    private List<AbstractLazyRenderingApplicationView> viewPeers = Collections.emptyList();

    public AbstractLazyRenderingApplicationView(View view, View targetView, ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
        this.view = view;
        this.targetView = targetView;
        this.visible.onChanged().addListener(isVisible -> {
            if (isVisible.booleanValue()) {
                this.onViewRedrawRequired.fire();
            }
        });
    }

    public void setPeerViews(AbstractLazyRenderingApplicationView ... views) {
        this.viewPeers = Arrays.asList(views).stream().filter(v -> !v.equals(this)).collect(Collectors.toList());
    }

    public abstract void createUi();

    public abstract Component getViewComponent();

    public void show(boolean select) {
        this.viewPeers.forEach(v -> v.visible.set((Object)false));
        this.visible.set((Object)true);
        if (!this.created) {
            long time = System.currentTimeMillis();
            this.createUi();
            System.out.println("Render " + this.getClass().getSimpleName() + ": " + (System.currentTimeMillis() - time));
            this.created = true;
        }
        this.view.setComponent(this.getViewComponent());
        this.view.setVisible(true);
        if (select) {
            this.view.focus();
        }
    }

    public void hide() {
        this.visible.set((Object)false);
        this.view.setVisible(false);
        this.viewPeers.forEach(v -> v.visible.set((Object)false));
    }

    public void focusTargetView() {
        if (this.targetView != null) {
            this.targetView.focus();
        }
    }

    public boolean isVisible() {
        return (Boolean)this.visible.get();
    }

    public View getView() {
        return this.view;
    }

    public View getTargetView() {
        return this.targetView;
    }
}

