/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.teamapps.application.api.application.AbstractApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.ux.org.OrganizationViewUtils;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.component.tree.TreeNodeInfoImpl;
import org.teamapps.ux.model.ListTreeModel;

public class OrganizationTree
extends AbstractApplicationView {
    private Tree<OrganizationUnitView> tree;
    private ListTreeModel<OrganizationUnitView> treeModel = new ListTreeModel(Collections.emptyList());
    private Set<OrganizationUnitView> organizationUnits;

    public OrganizationTree(ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
        this.tree = new Tree(this.treeModel);
        this.treeModel.setTreeNodeInfoFunction(unit -> new TreeNodeInfoImpl(unit.getParent() != null && this.organizationUnits.contains(unit.getParent()) ? unit.getParent() : null, false));
        this.tree.setPropertyProvider(OrganizationViewUtils.creatOrganizationUnitPropertyProvider(this.getApplicationInstanceData()));
        this.tree.setEntryTemplate((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
    }

    public void setTemplate(Template template) {
        this.tree.setEntryTemplate(template);
    }

    public void setOrganizationUnits(Collection<OrganizationUnitView> units) {
        this.organizationUnits = new HashSet<OrganizationUnitView>(units);
        this.treeModel.setRecords(new ArrayList<OrganizationUnitView>(units));
    }

    public Tree<OrganizationUnitView> getTree() {
        return this.tree;
    }
}

