/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.event.Level;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.entity.EntityUpdate;
import org.teamapps.application.api.application.perspective.ApplicationPerspective;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.desktop.ApplicationDesktop;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.RoleAssignmentDelegatedCustomPrivilegeGroup;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.application.api.ui.UiComponentFactory;
import org.teamapps.application.api.user.LocalizedFormatter;
import org.teamapps.application.api.user.SessionUser;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationFieldView;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.reporting.convert.DocumentConverter;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.component.progress.MultiProgressDisplay;
import org.teamapps.ux.resource.Resource;
import org.teamapps.ux.session.SessionContext;

public interface ApplicationInstanceDataMethods {
    public ApplicationInstanceData getApplicationInstanceData();

    default public OrganizationFieldView getOrganizationFieldView() {
        return this.getApplicationInstanceData().getOrganizationField();
    }

    default public int getManagedApplicationId() {
        return this.getApplicationInstanceData().getManagedApplicationId();
    }

    default public DocumentConverter getDocumentConverter() {
        return this.getApplicationInstanceData().getDocumentConverter();
    }

    default public UiComponentFactory getComponentFactory() {
        return this.getApplicationInstanceData().getComponentFactory();
    }

    default public SessionContext getContext() {
        return this.getApplicationInstanceData().getUser().getSessionContext();
    }

    default public void writeActivityLog(Level level, String title, String data) {
        this.getApplicationInstanceData().writeActivityLog(level, title, data);
    }

    default public void writeExceptionLog(Level level, String title, Throwable throwable) {
        this.getApplicationInstanceData().writeExceptionLog(level, title, throwable);
    }

    default public SessionUser getUser() {
        return this.getApplicationInstanceData().getUser();
    }

    default public MultiProgressDisplay getMultiProgressDisplay() {
        return this.getApplicationInstanceData().getMultiProgressDisplay();
    }

    default public LocalizedFormatter getLocalizedFormatter() {
        return this.getApplicationInstanceData().getLocalizedFormatter();
    }

    default public <RESULT> void runTaskAsync(Icon icon, String title, Supplier<RESULT> task, Consumer<RESULT> uiResultTask) {
        this.getApplicationInstanceData().runTaskAsync(icon, title, task, uiResultTask);
    }

    default public void showPerspective(Perspective perspective) {
        this.getApplicationInstanceData().showPerspective(perspective);
    }

    default public ApplicationPerspective showApplicationPerspective(String perspectiveName) {
        return this.getApplicationInstanceData().showApplicationPerspective(perspectiveName);
    }

    default public ApplicationDesktop createApplicationDesktop() {
        return this.getApplicationInstanceData().createApplicationDesktop();
    }

    default public ApplicationConfig<?> getApplicationConfig() {
        return this.getApplicationInstanceData().getApplicationConfig();
    }

    default public String getLocalized(String key, Object ... parameters) {
        return this.getApplicationInstanceData().getLocalized(key, parameters);
    }

    default public String getLocalized(String key, List<String> languagePriorityOrder, Object ... parameters) {
        return this.getApplicationInstanceData().getLocalized(key, languagePriorityOrder, parameters);
    }

    default public String getLocalized(String key, String language, Object ... parameters) {
        return this.getLocalized(key, Collections.singletonList(language), parameters);
    }

    default public String getLocalized(String key, Locale locale, Object ... parameters) {
        return this.getLocalized(key, Collections.singletonList(locale.getLanguage()), parameters);
    }

    default public String getLocalized(TranslatableText translatableText) {
        return this.getApplicationInstanceData().getLocalized(translatableText);
    }

    default public Function<TranslatableText, String> getTranslatableTextExtractor() {
        return this.getApplicationInstanceData().getTranslatableTextExtractor();
    }

    default public boolean isAllowed(SimplePrivilege simplePrivilege) {
        return this.getApplicationInstanceData().isAllowed(simplePrivilege);
    }

    default public boolean isAllowed(SimpleOrganizationalPrivilege group, OrganizationUnitView OrganizationUnitView2) {
        return this.getApplicationInstanceData().isAllowed(group, OrganizationUnitView2);
    }

    default public boolean isAllowed(SimpleCustomObjectPrivilege group, PrivilegeObject privilegeObject) {
        return this.getApplicationInstanceData().isAllowed(group, privilegeObject);
    }

    default public boolean isAllowed(StandardPrivilegeGroup group, Privilege privilege) {
        return this.getApplicationInstanceData().isAllowed(group, privilege);
    }

    default public boolean isAllowed(OrganizationalPrivilegeGroup group, Privilege privilege, OrganizationUnitView OrganizationUnitView2) {
        return this.getApplicationInstanceData().isAllowed(group, privilege, OrganizationUnitView2);
    }

    default public boolean isAllowed(CustomObjectPrivilegeGroup group, Privilege privilege, PrivilegeObject privilegeObject) {
        return this.getApplicationInstanceData().isAllowed(group, privilege, privilegeObject);
    }

    default public boolean isAllowed(RoleAssignmentDelegatedCustomPrivilegeGroup group, Privilege privilege, PrivilegeObject privilegeObject) {
        return this.getApplicationInstanceData().isAllowed(group, privilege, privilegeObject);
    }

    default public List<OrganizationUnitView> getAllowedUnits(SimpleOrganizationalPrivilege simplePrivilege) {
        return this.getApplicationInstanceData().getAllowedUnits(simplePrivilege);
    }

    default public List<OrganizationUnitView> getAllowedUnits(OrganizationalPrivilegeGroup group, Privilege privilege) {
        return this.getApplicationInstanceData().getAllowedUnits(group, privilege);
    }

    default public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege simplePrivilege) {
        return this.getApplicationInstanceData().getAllowedPrivilegeObjects(simplePrivilege);
    }

    default public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup group, Privilege privilege) {
        return this.getApplicationInstanceData().getAllowedPrivilegeObjects(group, privilege);
    }

    default public List<PrivilegeObject> getAllowedPrivilegeObjects(RoleAssignmentDelegatedCustomPrivilegeGroup group, Privilege privilege) {
        return this.getApplicationInstanceData().getAllowedPrivilegeObjects(group, privilege);
    }

    default public <ENTITY> void registerEntityUpdateListener(EntityBuilder<ENTITY> entityBuilder, Consumer<EntityUpdate<ENTITY>> listener) {
        this.getApplicationInstanceData().registerEntityUpdateListener(entityBuilder, listener);
    }

    default public String createPublicLinkForResource(Resource resource, Duration availabilityDuration) {
        return this.getApplicationInstanceData().createPublicLinkForResource(resource, availabilityDuration);
    }
}

