/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.teamapps.application.api.state.ReplicatedList;
import org.teamapps.application.api.state.ReplicatedProperty;
import org.teamapps.cluster.state.ReplicatedState;
import org.teamapps.cluster.state.ReplicatedStateHandler;
import org.teamapps.cluster.state.ReplicatedStateTransactionRule;
import org.teamapps.cluster.state.StateUpdate;
import org.teamapps.cluster.state.StateUpdateMessage;
import org.teamapps.protocol.schema.MessageObject;
import org.teamapps.protocol.schema.PojoObjectDecoder;

public class ReplicatedStateMachine
implements ReplicatedStateHandler {
    private final ReplicatedState replicatedState;
    private final Map<String, ReplicatedList<? extends MessageObject>> replicatedListByName = new HashMap<String, ReplicatedList<? extends MessageObject>>();
    private final Map<String, ReplicatedProperty<? extends MessageObject>> replicatedPropertyByName = new HashMap<String, ReplicatedProperty<? extends MessageObject>>();
    private final List<StateUpdateMessage> preparedUpdates = new ArrayList<StateUpdateMessage>();
    private final List<ReplicatedStateTransactionRule> transactionRules = new ArrayList<ReplicatedStateTransactionRule>();

    public ReplicatedStateMachine(ReplicatedState replicatedState) {
        this.replicatedState = replicatedState;
    }

    public synchronized <TYPE extends MessageObject> ReplicatedList<TYPE> getOrCreateList(String name, PojoObjectDecoder<TYPE> messageDecoder, Function<TYPE, String> typeToIdFunction) {
        return this.replicatedListByName.computeIfAbsent(name, s -> new ReplicatedList(this.replicatedState, name, messageDecoder, typeToIdFunction, this.preparedUpdates, this.transactionRules));
    }

    public synchronized <TYPE extends MessageObject> ReplicatedProperty<TYPE> getOrCreateProperty(String name, PojoObjectDecoder<TYPE> messageDecoder) {
        return this.replicatedPropertyByName.computeIfAbsent(name, s -> new ReplicatedProperty(this.replicatedState, (String)s, messageDecoder, this.preparedUpdates));
    }

    public void executePreparedUpdates() {
        this.replicatedState.executeStateMachineUpdate(new StateUpdate(this.replicatedState.getName(), this.preparedUpdates, this.transactionRules));
        this.preparedUpdates.clear();
        this.transactionRules.clear();
    }

    private ReplicatedList<? extends MessageObject> getReplicatedList(String name) {
        return this.replicatedListByName.get(name);
    }

    private ReplicatedProperty<? extends MessageObject> getReplicatedProperty(String name) {
        return this.replicatedPropertyByName.get(name);
    }

    public void handleStateUpdated(String stateId, MessageObject state) {
        ReplicatedProperty<? extends MessageObject> replicatedProperty = this.getReplicatedProperty(stateId);
        if (replicatedProperty != null) {
            replicatedProperty.handleSetState(state);
        }
    }

    public void handleEntryAdded(String list, MessageObject message) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getReplicatedList(list);
        if (replicatedList != null) {
            replicatedList.handleEntryAdded(message);
        }
    }

    public void handleEntryRemoved(String list, MessageObject message) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getReplicatedList(list);
        if (replicatedList != null) {
            replicatedList.handleEntryRemoved(message);
        }
    }

    public void handleEntryUpdated(String list, MessageObject currentState, MessageObject previousState) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getReplicatedList(list);
        if (replicatedList != null) {
            replicatedList.handleEntryUpdated(currentState);
        }
    }

    public void handleAllEntriesRemoved(String list) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getReplicatedList(list);
        if (replicatedList != null) {
            replicatedList.handleAllEntriesRemoved();
        }
    }

    public void handleFireAndForget(String list, MessageObject message) {
        ReplicatedList<? extends MessageObject> replicatedList = this.getReplicatedList(list);
        if (replicatedList != null) {
            replicatedList.handleFireAndForget(message);
        }
    }

    public void handleStateMachineRemoved() {
    }
}

