/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.application.ApplicationInstanceDataMethods;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.tools.RecordModelBuilder;
import org.teamapps.application.tools.TimeIntervalFilter;
import org.teamapps.application.ux.combo.ComboBoxUtils;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationUnitView;
import org.teamapps.universaldb.context.UserContext;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.AbstractUdbQuery;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.timegraph.TimeGraph;

public class EntityModelBuilder<ENTITY extends Entity<ENTITY>>
extends RecordModelBuilder<ENTITY>
implements ApplicationInstanceDataMethods {
    private final Supplier<Query<ENTITY>> querySupplier;
    private final TableIndex tableIndex;
    private final EntityBuilder<ENTITY> entityBuilder;
    private boolean showDeletedRecords;

    public EntityModelBuilder(Supplier<Query<ENTITY>> querySupplier, ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
        this.querySupplier = querySupplier;
        AbstractUdbQuery udbQuery = (AbstractUdbQuery)querySupplier.get();
        this.tableIndex = udbQuery.getTableIndex();
        this.entityBuilder = udbQuery.getEntityBuilder();
    }

    public TableIndex getTableIndex() {
        return this.tableIndex;
    }

    public EntityBuilder<ENTITY> getEntityBuilder() {
        return this.entityBuilder;
    }

    public boolean matchesQuery(Entity<ENTITY> entity) {
        return this.querySupplier.get().matches(entity);
    }

    public boolean containsEntity(Entity<ENTITY> entity) {
        return this.querySupplier.get().matches(entity);
    }

    @Override
    public List<ENTITY> queryRecords(String fullTextQuery, TimeIntervalFilter timeIntervalFilter) {
        List entities;
        AbstractUdbQuery query = (AbstractUdbQuery)this.querySupplier.get();
        if (timeIntervalFilter != null) {
            NumericFilter numericFilter = this.tableIndex.getColumnIndex(timeIntervalFilter.getFieldName()).getType() == IndexType.INT ? timeIntervalFilter.getIntFilter() : timeIntervalFilter.getFilter();
            query.addNumericFilter(timeIntervalFilter.getFieldName(), numericFilter);
        }
        if (this.getCustomFullTextFilter() == null && fullTextQuery != null && !fullTextQuery.isBlank()) {
            query.addFullTextQuery(fullTextQuery, new String[0]);
        }
        List list = entities = this.getSortField() != null && this.getCustomFieldSorter() == null ? query.execute(this.showDeletedRecords, this.getSortField(), this.isSortAscending(), (UserContext)this.getUser(), new String[0]) : query.execute(this.showDeletedRecords);
        if (this.getCustomFullTextFilter() != null && fullTextQuery != null && !fullTextQuery.isBlank()) {
            BiFunction customFullTextFilter = this.getCustomFullTextFilter();
            String fullTextSearchQuery = fullTextQuery.toLowerCase();
            return entities.stream().filter(entity -> (Boolean)customFullTextFilter.apply(entity, fullTextSearchQuery)).collect(Collectors.toList());
        }
        return entities;
    }

    public void setShowDeletedRecords(boolean showDeletedRecords) {
        this.showDeletedRecords = showDeletedRecords;
        this.onDataChanged.fire();
    }

    public boolean isShowDeletedRecords() {
        return this.showDeletedRecords;
    }

    public TimeGraph createTimeGraph() {
        return this.createTimeGraph(this.createEntityFieldTimeFunction("metaModificationDate"), "metaModificationDate");
    }

    public ComboBox<String> createTimeGraphFieldSelectionCombobox(TimeGraph timeGraph) {
        Supplier timeFieldsSupplier = () -> this.tableIndex.getColumnIndices().stream().filter(col -> col.getColumnType() == ColumnType.TIMESTAMP || col.getColumnType() == ColumnType.DATE_TIME).map(ColumnIndex::getName).filter(name -> !"metaDeletionDate".equals(name) || this.showDeletedRecords).collect(Collectors.toList());
        PropertyProvider propertyProvider = (s, propertyNames) -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("icon", this.getFieldIcon((String)s));
            map.put("caption", this.getFieldTitle((String)s));
            return map;
        };
        ComboBox comboBox = ComboBoxUtils.createRecordComboBox(timeFieldsSupplier, propertyProvider, (Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        comboBox.onValueChanged.addListener(fieldName -> {
            Function<ENTITY, Long> recordTimeFunction = this.createEntityFieldTimeFunction((String)fieldName);
            this.updateTimeGraphRecordTimeFunction(recordTimeFunction, (String)fieldName, timeGraph);
        });
        comboBox.setValue((Object)"metaModificationDate");
        return comboBox;
    }

    private Function<ENTITY, Long> createEntityFieldTimeFunction(String fieldName) {
        Function<Entity, Long> recordTimeFunction;
        ColumnIndex columnIndex = this.tableIndex.getColumnIndex(fieldName);
        if (columnIndex.getColumnType() == ColumnType.DATE_TIME) {
            LongIndex longIndex = (LongIndex)columnIndex;
            recordTimeFunction = entity -> {
                AbstractUdbEntity udbEntity = (AbstractUdbEntity)entity;
                long value = udbEntity.getDateTimeAsEpochMilli(longIndex);
                return value == 0L ? null : Long.valueOf(value);
            };
        } else {
            IntegerIndex integerIndex = (IntegerIndex)columnIndex;
            recordTimeFunction = entity -> {
                AbstractUdbEntity udbEntity = (AbstractUdbEntity)entity;
                long value = udbEntity.getTimestampAsEpochMilli(integerIndex);
                return value == 0L ? null : Long.valueOf(value);
            };
        }
        return recordTimeFunction;
    }

    private String getFieldTitle(String fieldName) {
        return switch (fieldName) {
            case "metaCreationDate" -> this.getLocalized("org.teamapps.dictionary.creationDate", new Object[0]);
            case "metaModificationDate" -> this.getLocalized("org.teamapps.dictionary.modificationDate", new Object[0]);
            case "metaDeletionDate" -> this.getLocalized("org.teamapps.dictionary.deletionDate", new Object[0]);
            case "metaRestoreDate" -> this.getLocalized("org.teamapps.dictionary.restoreDate", new Object[0]);
            default -> fieldName;
        };
    }

    private Icon<?, ?> getFieldIcon(String fieldName) {
        return switch (fieldName) {
            case "metaCreationDate" -> ApplicationIcons.ADD;
            case "metaModificationDate" -> ApplicationIcons.EDIT;
            case "metaDeletionDate" -> ApplicationIcons.GARBAGE_EMPTY;
            case "metaRestoreDate" -> ApplicationIcons.GARBAGE_MAKE_EMPTY;
            default -> ApplicationIcons.CALENDAR;
        };
    }

    public Function<ENTITY, OrganizationUnitView> createEntityOrganizationUnitViewFunction() {
        SingleReferenceIndex index;
        SingleReferenceIndex referenceIndex = null;
        for (ColumnIndex columnIndex : this.tableIndex.getColumnIndices()) {
            SingleReferenceIndex singleReferenceIndex;
            String fqn;
            if (columnIndex.getColumnType() != ColumnType.SINGLE_REFERENCE || !(fqn = (singleReferenceIndex = (SingleReferenceIndex)columnIndex).getReferencedTable().getFQN()).equals("controlCenter.organizationUnitView") && !fqn.equals("controlCenter.organizationUnit")) continue;
            referenceIndex = singleReferenceIndex;
            break;
        }
        if ((index = referenceIndex) == null) {
            return null;
        }
        return entity -> {
            if (entity == null) {
                return null;
            }
            int id = index.getValue(entity.getId());
            return id == 0 ? null : OrganizationUnitView.getById((int)id);
        };
    }
}

