/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.form;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.ux.component.field.validator.FieldValidator;

public class FormValidationUtils {
    public static Pattern PHONE_NUMBER_PATTERN = Pattern.compile("^[+0-9.\\-\\s()]+$");
    public static final Pattern E_MAIL_ADDRESS_PATTERN = Pattern.compile("^[a-zA-Z0-9_+&*-]+(?:\\.[a-zA-Z0-9_+&*-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,7}$");

    public static FieldValidator<?> createNotNullValidator(ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(Objects::nonNull, (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.pleaseEnterAValue", new Object[0]));
    }

    public static FieldValidator<String> createNotBlankValidator(ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(s -> FormValidationUtils.isNotNullOrBlank(s) && s.length() > 0, (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.pleaseEnterAValue", new Object[0]));
    }

    public static FieldValidator<?> createNotEmptyListValidator(ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(list -> list instanceof List && !((List)list).isEmpty(), (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.pleaseEnterAValue", new Object[0]));
    }

    public static FieldValidator<String> createEmailValidator(ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(s -> FormValidationUtils.isNotNullOrBlank(s) && E_MAIL_ADDRESS_PATTERN.matcher((CharSequence)s).matches(), (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.notAValidEmailAddress", new Object[0]));
    }

    public static FieldValidator<String> createEmailOrEmptyValidator(ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(s -> FormValidationUtils.isEmpty(s) || E_MAIL_ADDRESS_PATTERN.matcher((CharSequence)s).matches(), (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.notAValidEmailAddress", new Object[0]));
    }

    public static FieldValidator<String> createPhoneNumberValidator(ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(s -> FormValidationUtils.isNotNullOrBlank(s) && PHONE_NUMBER_PATTERN.matcher((CharSequence)s).matches(), (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.notAValidPhoneNumber", new Object[0]));
    }

    public static FieldValidator<String> createPhoneNumberOrEmptyValidator(ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(s -> FormValidationUtils.isEmpty(s) || PHONE_NUMBER_PATTERN.matcher((CharSequence)s).matches(), (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.notAValidPhoneNumber", new Object[0]));
    }

    public static FieldValidator<String> createMinCharactersValidator(int minCharacters, ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(s -> FormValidationUtils.isNotNullOrBlank(s) && s.length() >= minCharacters, (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.theFieldMustContainAtLeast0Characters", minCharacters));
    }

    public static FieldValidator<String> createMinCharactersOrEmptyValidator(int minCharacters, ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(s -> FormValidationUtils.isEmpty(s) || s.length() >= minCharacters, (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.theFieldMustContainAtLeast0Characters", minCharacters));
    }

    public static FieldValidator<String> createMinCharactersValidator(int minCharacters, String fieldCaption, ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(s -> FormValidationUtils.isNotNullOrBlank(s) && s.length() >= minCharacters, (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.theField0MustContainAtLeast1Characters", fieldCaption, minCharacters));
    }

    public static FieldValidator<String> createMaxCharactersValidator(int maxCharacters, ApplicationInstanceData applicationInstanceData) {
        return FieldValidator.fromPredicate(s -> FormValidationUtils.isNotNullOrBlank(s) && s.length() < maxCharacters, (String)applicationInstanceData.getLocalized("org.teamapps.dictionary.theFieldMustContainLessThan0Characters", maxCharacters));
    }

    private static boolean isNotNullOrBlank(String s) {
        return s != null && !s.isBlank();
    }

    private static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

