/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.map;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.application.api.application.AbstractLazyRenderingApplicationView;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.ux.map.MapMarkerData;
import org.teamapps.common.format.Color;
import org.teamapps.dto.UiMapConfig;
import org.teamapps.event.Event;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.map.Location;
import org.teamapps.ux.component.map.MapShapeType;
import org.teamapps.ux.component.map.MapView;
import org.teamapps.ux.component.map.MapView2;
import org.teamapps.ux.component.map.Marker;
import org.teamapps.ux.component.map.shape.MapPolyline;
import org.teamapps.ux.component.map.shape.ShapeProperties;
import org.teamapps.ux.component.panel.Panel;

public class MapViewer<ENTITY>
extends AbstractLazyRenderingApplicationView {
    public static final String DEFAULT_BRIGHT_STILE = "osm-liberty-intl";
    public static final String DEFAULT_DARK_STILE = "osm_liberty_dark_custom_intl";
    public final Event<MapMarkerData<ENTITY>> onMarkerClicked = new Event();
    private final String mapServer;
    private final String mapStyle;
    private String mapKey;
    private MapView<MapMarkerData<ENTITY>> tileMap;
    private MapView2<MapMarkerData<ENTITY>> vectorMap;
    private Panel panel;
    private Function<ENTITY, MapMarkerData<ENTITY>> entityToMarkerDataFunction;
    private boolean vectorMapVisible;
    private List<Marker<MapMarkerData<ENTITY>>> visibleMarkers = new ArrayList<Marker<MapMarkerData<ENTITY>>>();

    public MapViewer(String mapServer, String mapStyle, ApplicationInstanceData applicationInstanceData) {
        super(applicationInstanceData);
        this.mapServer = mapServer;
        this.mapStyle = mapStyle;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public void setEntityToMarkerDataFunction(Function<ENTITY, MapMarkerData<ENTITY>> entityToMarkerDataFunction) {
        this.entityToMarkerDataFunction = entityToMarkerDataFunction;
    }

    public void showEntities(ENTITY ... entities) {
        this.showEntities(Arrays.asList(entities));
    }

    public void showEntities(List<ENTITY> entities) {
        this.showMarkers(entities.stream().map(entity -> this.entityToMarkerDataFunction.apply(entity)).filter(Objects::nonNull).filter(marker -> marker.getLocation() != null).collect(Collectors.toList()));
    }

    public void showMarkers(MapMarkerData<ENTITY> ... markers) {
        this.showMarkers(Arrays.asList(markers));
    }

    public void showMarkers(List<MapMarkerData<ENTITY>> markerDataList) {
        this.showMapMarkers(markerDataList.stream().map(data -> new Marker(data.getLocation(), data, data.getOffsetX(), data.getOffsetY())).collect(Collectors.toList()));
    }

    private void showMapMarkers(List<Marker<MapMarkerData<ENTITY>>> markers) {
        this.clearMap();
        DoubleSummaryStatistics latStatistics = markers.stream().mapToDouble(marker -> marker.getLocation().getLatitude()).summaryStatistics();
        DoubleSummaryStatistics lonStatistics = markers.stream().mapToDouble(marker -> marker.getLocation().getLongitude()).summaryStatistics();
        if (markers.size() > 1000) {
            this.panel.setContent(this.tileMap);
            this.vectorMapVisible = false;
            this.tileMap.setMarkerCluster(markers);
            this.tileMap.fitBounds(new Location(latStatistics.getMin(), lonStatistics.getMin()), new Location(latStatistics.getMax(), lonStatistics.getMax()));
        } else {
            this.panel.setContent(this.vectorMap);
            this.vectorMapVisible = true;
            markers.forEach(marker -> this.vectorMap.addMarker(marker));
            if (markers.size() > 1) {
                this.vectorMap.fitBounds(new Location(latStatistics.getMin(), lonStatistics.getMin()), new Location(latStatistics.getMax(), lonStatistics.getMax()));
            } else if (markers.size() == 1) {
                this.vectorMap.setLocation(markers.get(0).getLocation(), 0L, 15);
            }
        }
    }

    public void drawLine(Location loc1, Location loc2) {
        this.vectorMap.addPolyLine(new MapPolyline(List.of(loc1, loc2), new ShapeProperties((Color)Color.MATERIAL_ORANGE_700, 1.0f)));
    }

    public void clearMap() {
        if (this.vectorMapVisible) {
            this.vectorMap.clearMarkers();
            this.vectorMap.clearShapes();
        } else {
            this.tileMap.clearMarkers();
        }
    }

    public void draw() {
        if (!this.vectorMapVisible) {
            this.tileMap.startDrawingShape(MapShapeType.RECTANGLE, new ShapeProperties((Color)Color.MATERIAL_ORANGE_700, 1.5f, (Color)Color.MATERIAL_ORANGE_700.withAlpha(0.6f)));
        }
    }

    @Override
    public void createUi() {
        this.panel = new Panel();
        this.panel.setHideTitleBar(true);
        this.panel.setCssStyle("border", "none");
        this.tileMap = this.createTileMap();
        this.vectorMap = this.createVectorMap();
        this.tileMap.onMarkerClicked.addListener(marker -> this.onMarkerClicked.fire((Object)((MapMarkerData)marker.getData())));
        this.vectorMap.onMarkerClicked.addListener(marker -> this.onMarkerClicked.fire((Object)((MapMarkerData)marker.getData())));
    }

    private MapView<MapMarkerData<ENTITY>> createTileMap() {
        MapView mapView = new MapView();
        String url = this.mapServer + "/styles/" + this.mapStyle + "/{z}/{x}/{y}.png?key=" + this.mapKey;
        UiMapConfig config = new UiMapConfig();
        config.setUrlTemplate(url);
        config.setMinZoom(0);
        config.setMaxZoom(20);
        mapView.setMapConfig(config);
        mapView.setMarkerTemplateDecider(marker -> ((MapMarkerData)marker.getData()).getTemplate());
        mapView.setZoomLevel(6);
        mapView.setMarkerPropertyProvider((mapMarkerData, propertyNames) -> mapMarkerData.getTemplateData());
        return mapView;
    }

    private MapView2<MapMarkerData<ENTITY>> createVectorMap() {
        MapView2 mapView = new MapView2(this.mapServer, "ac", this.mapStyle + "/styles/" + this.mapStyle + "/style.json?key=" + this.mapKey);
        mapView.setMarkerTemplateDecider(marker -> ((MapMarkerData)marker.getData()).getTemplate());
        mapView.setZoomLevel(6);
        mapView.setMarkerPropertyProvider((mapMarkerData, propertyNames) -> mapMarkerData.getTemplateData());
        mapView.setDisplayAttributionControl(false);
        return mapView;
    }

    @Override
    public Component getViewComponent() {
        return this.panel;
    }
}

