/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.state;

import java.util.List;
import org.teamapps.cluster.state.ReplicatedState;
import org.teamapps.cluster.state.StateUpdateMessage;
import org.teamapps.event.Event;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.message.protocol.model.PojoObjectDecoder;

public class ReplicatedProperty<TYPE extends Message> {
    private final ReplicatedState distributedStateMachine;
    private final String stateName;
    private final List<StateUpdateMessage> preparedUpdates;
    private final PojoObjectDecoder<TYPE> messageDecoder;
    public Event<TYPE> onStateChanged = new Event();

    protected ReplicatedProperty(ReplicatedState distributedStateMachine, String stateName, PojoObjectDecoder<TYPE> messageDecoder, List<StateUpdateMessage> preparedUpdates) {
        this.distributedStateMachine = distributedStateMachine;
        this.stateName = stateName;
        this.preparedUpdates = preparedUpdates;
        this.messageDecoder = messageDecoder;
    }

    public void prepareUpdateState(TYPE state) {
        this.preparedUpdates.add(this.distributedStateMachine.prepareSetState(this.stateName, state));
    }

    public void setState(TYPE state) {
        this.distributedStateMachine.setProperty(this.stateName, state);
    }

    public TYPE getProperty() {
        return this.remap(this.distributedStateMachine.getProperty(this.stateName));
    }

    protected void handleSetState(Message state) {
        this.onStateChanged.fire(this.remap(state));
    }

    protected TYPE remap(Message message) {
        return (TYPE)(message != null ? this.messageDecoder.remap(message) : null);
    }
}

