/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.state;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.cluster.state.LocalState;
import org.teamapps.cluster.state.ReplicatedState;
import org.teamapps.cluster.state.ReplicatedStateHandler;
import org.teamapps.message.protocol.message.Message;
import org.teamapps.ux.session.SessionContext;

public class MultiStateHandler
implements ReplicatedStateHandler {
    private List<ReplicatedStateHandler> stateHandlers = new ArrayList<ReplicatedStateHandler>();
    private ReplicatedState replicatedState;

    public MultiStateHandler(String name) {
        LocalState localState = new LocalState(name);
        localState.setHandler((ReplicatedStateHandler)this);
        this.replicatedState = localState;
    }

    public ReplicatedState getReplicatedState() {
        return this.replicatedState;
    }

    public synchronized void addStateHandler(ReplicatedStateHandler stateHandler, SessionContext context) {
        this.stateHandlers.add(stateHandler);
        context.onDestroyed.addListener(() -> this.removeStateHandler(stateHandler));
    }

    private synchronized void removeStateHandler(ReplicatedStateHandler stateHandler) {
        this.stateHandlers.remove(stateHandler);
    }

    public synchronized void handleStateUpdated(String stateId, Message state) {
        this.stateHandlers.forEach(stateHandler -> stateHandler.handleStateUpdated(stateId, state));
    }

    public synchronized void handleEntryAdded(String list, Message message) {
        this.stateHandlers.forEach(stateHandler -> stateHandler.handleEntryAdded(list, message));
    }

    public synchronized void handleEntryRemoved(String list, Message message) {
        this.stateHandlers.forEach(stateHandler -> stateHandler.handleEntryRemoved(list, message));
    }

    public synchronized void handleEntryUpdated(String list, Message currentState, Message previousState) {
        this.stateHandlers.forEach(stateHandler -> stateHandler.handleEntryUpdated(list, currentState, previousState));
    }

    public synchronized void handleAllEntriesRemoved(String list) {
        this.stateHandlers.forEach(stateHandler -> stateHandler.handleAllEntriesRemoved(list));
    }

    public synchronized void handleFireAndForget(String list, Message message) {
        this.stateHandlers.forEach(stateHandler -> stateHandler.handleFireAndForget(list, message));
    }

    public synchronized void handleStateMachineRemoved() {
        this.stateHandlers.forEach(ReplicatedStateHandler::handleStateMachineRemoved);
    }
}

