/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.map;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.application.ux.map.MapTemplates;
import org.teamapps.ux.component.map.Location;
import org.teamapps.ux.component.template.Template;

public class MapMarkerData<ENTITY> {
    private final Location location;
    private final Template template;
    private ENTITY entity;
    private Map<String, Object> templateData = new HashMap<String, Object>();
    private int offsetX;
    private int offsetY;

    public MapMarkerData(Location location, MapTemplates template) {
        this.location = location;
        this.template = template;
        this.offsetX = template.getOffsetX();
        this.offsetY = template.getOffsetY();
    }

    public MapMarkerData(Location location, Template template) {
        this.location = location;
        this.template = template;
    }

    public MapMarkerData(ENTITY entity, Location location, Template template) {
        this.entity = entity;
        this.location = location;
        this.template = template;
    }

    public void setImage(String image) {
        this.templateData.put("image", image);
    }

    public void setCaption(String caption) {
        this.templateData.put("caption", caption);
    }

    public void setDescription(String description) {
        this.templateData.put("description", description);
    }

    public ENTITY getEntity() {
        return this.entity;
    }

    public void setEntity(ENTITY entity) {
        this.entity = entity;
    }

    public Location getLocation() {
        return this.location;
    }

    public Template getTemplate() {
        return this.template;
    }

    public Map<String, Object> getTemplateData() {
        return this.templateData;
    }

    public void setTemplateData(Map<String, Object> templateData) {
        this.templateData = templateData;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }
}

