/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.form;

import java.time.Instant;
import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.ui.FormMetaFields;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.universaldb.index.FieldIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.form.ResponsiveFormSection;
import org.teamapps.ux.component.format.SizingPolicy;

public class FormMetaFieldsImpl
implements FormMetaFields {
    private final ApplicationInstanceData applicationInstanceData;
    private final TemplateField<Integer> createdByField;
    private final TemplateField<Integer> modifiedByField;
    private final TemplateField<Integer> deletedByField;
    private final TemplateField<Integer> restoredByField;
    private final InstantDateTimeField creationDateField;
    private final InstantDateTimeField modificationDateField;
    private final InstantDateTimeField deletionDateField;
    private final InstantDateTimeField restoreDateField;

    public FormMetaFieldsImpl(ApplicationInstanceData applicationInstanceData) {
        this.applicationInstanceData = applicationInstanceData;
        this.createdByField = applicationInstanceData.getComponentFactory().createUserTemplateField();
        this.modifiedByField = applicationInstanceData.getComponentFactory().createUserTemplateField();
        this.deletedByField = applicationInstanceData.getComponentFactory().createUserTemplateField();
        this.restoredByField = applicationInstanceData.getComponentFactory().createUserTemplateField();
        this.creationDateField = new InstantDateTimeField();
        this.modificationDateField = new InstantDateTimeField();
        this.deletionDateField = new InstantDateTimeField();
        this.restoreDateField = new InstantDateTimeField();
        this.creationDateField.setEditingMode(FieldEditingMode.READONLY);
        this.modificationDateField.setEditingMode(FieldEditingMode.READONLY);
        this.deletionDateField.setEditingMode(FieldEditingMode.READONLY);
        this.restoreDateField.setEditingMode(FieldEditingMode.READONLY);
    }

    @Override
    public ResponsiveFormSection addMetaFields(ResponsiveFormLayout formLayout, boolean withIcons, Event<? extends Entity<?>> onEntityChange) {
        onEntityChange.addListener(this::updateEntity);
        return this.addMetaFields(formLayout, withIcons);
    }

    @Override
    public ResponsiveFormSection addMetaFields(ResponsiveFormLayout formLayout, boolean withIcons) {
        Icon dateIcon = withIcons ? ApplicationIcons.CALENDAR_CLOCK : null;
        Icon userIcon = withIcons ? ApplicationIcons.USER : null;
        ResponsiveFormSection formSection = formLayout.addSection(ApplicationIcons.WINDOW_SIDEBAR, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.metaData", new Object[0])).setCollapsed(false);
        formLayout.addLabelAndField((Icon)userIcon, (String)this.applicationInstanceData.getLocalized((String)"org.teamapps.dictionary.creation", (Object[])new Object[0]), (AbstractField)this.creationDateField).field.getColumnDefinition().setWidthPolicy(SizingPolicy.AUTO);
        formLayout.addLabelAndField(null, null, this.createdByField, (boolean)false).field.getColumnDefinition().setWidthPolicy(SizingPolicy.FRACTION);
        formLayout.addLabelAndField(dateIcon, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.modification", new Object[0]), (AbstractField)this.modificationDateField);
        formLayout.addLabelAndField(null, null, this.modifiedByField, false);
        formLayout.addLabelAndField(dateIcon, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.deleted", new Object[0]), (AbstractField)this.deletionDateField);
        formLayout.addLabelAndField(null, null, this.deletedByField, false);
        formLayout.addLabelAndField(dateIcon, this.applicationInstanceData.getLocalized("org.teamapps.dictionary.restored", new Object[0]), (AbstractField)this.restoreDateField);
        formLayout.addLabelAndField(null, null, this.restoredByField, false);
        return formSection;
    }

    @Override
    public void updateEntity(Entity<?> entity) {
        if (entity instanceof AbstractUdbEntity) {
            AbstractUdbEntity udbEntity = (AbstractUdbEntity)entity;
            TableIndex tableIndex = udbEntity.getTableIndex();
            FieldIndex createdByIndex = tableIndex.getFieldIndex("metaCreatedBy");
            FieldIndex modifiedByIndex = tableIndex.getFieldIndex("metaModifiedBy");
            FieldIndex deletedByIndex = tableIndex.getFieldIndex("metaDeletedBy");
            FieldIndex restoredByIndex = tableIndex.getFieldIndex("metaRestoredBy");
            FieldIndex creationDateIndex = tableIndex.getFieldIndex("metaCreationDate");
            FieldIndex modificationDateIndex = tableIndex.getFieldIndex("metaModificationDate");
            FieldIndex deletionDateIndex = tableIndex.getFieldIndex("metaDeletionDate");
            FieldIndex restoreDateIndex = tableIndex.getFieldIndex("metaRestoreDate");
            this.createdByField.setValue((Object)(createdByIndex != null ? udbEntity.getIntValue((IntegerIndex)createdByIndex) : 0));
            this.modifiedByField.setValue((Object)(modifiedByIndex != null ? udbEntity.getIntValue((IntegerIndex)modifiedByIndex) : 0));
            this.deletedByField.setValue((Object)(deletedByIndex != null ? udbEntity.getIntValue((IntegerIndex)deletedByIndex) : 0));
            this.restoredByField.setValue((Object)(restoredByIndex != null ? udbEntity.getIntValue((IntegerIndex)restoredByIndex) : 0));
            this.creationDateField.setValue(creationDateIndex != null ? udbEntity.getTimestampValue((IntegerIndex)creationDateIndex) : null);
            this.modificationDateField.setValue(modificationDateIndex != null ? udbEntity.getTimestampValue((IntegerIndex)modificationDateIndex) : null);
            this.deletionDateField.setValue(deletionDateIndex != null ? udbEntity.getTimestampValue((IntegerIndex)deletionDateIndex) : null);
            this.restoreDateField.setValue(restoreDateIndex != null ? udbEntity.getTimestampValue((IntegerIndex)restoreDateIndex) : null);
            boolean showModification = this.modificationDateField.getValue() != null && !((Instant)this.modificationDateField.getValue()).equals(this.creationDateField.getValue());
            this.createdByField.setVisible((Integer)this.createdByField.getValue() != 0);
            this.modifiedByField.setVisible(showModification);
            this.deletedByField.setVisible((Integer)this.deletedByField.getValue() != 0);
            this.restoredByField.setVisible((Integer)this.restoredByField.getValue() != 0);
            this.creationDateField.setVisible(this.creationDateField.getValue() != null);
            this.modificationDateField.setVisible(showModification);
            this.deletionDateField.setVisible((Integer)this.deletedByField.getValue() != 0);
            this.restoreDateField.setVisible((Integer)this.restoredByField.getValue() != 0);
        }
    }
}

