/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.server;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.application.api.server.SessionHandler;
import org.teamapps.application.api.server.SessionManager;
import org.teamapps.config.TeamAppsConfiguration;
import org.teamapps.model.SchemaInfo;
import org.teamapps.model.system.SystemStarts;
import org.teamapps.model.system.Type;
import org.teamapps.server.ServletRegistration;
import org.teamapps.server.undertow.embedded.TeamAppsUndertowEmbeddedServer;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.ux.resource.ClassPathResourceProvider;
import org.teamapps.ux.resource.ResourceProvider;
import org.teamapps.ux.resource.ResourceProviderServlet;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class ApplicationServer
implements WebController,
SessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final File basePath;
    private TeamAppsConfiguration teamAppsConfiguration;
    private int port;
    private UniversalDB universalDb;
    private List<ServletRegistration> servletRegistrations = new ArrayList<ServletRegistration>();
    private SessionHandler sessionHandler;

    public ApplicationServer(File basePath) {
        this(basePath, new TeamAppsConfiguration(), 8080);
    }

    public ApplicationServer(File basePath, TeamAppsConfiguration teamAppsConfiguration, int port) {
        this.basePath = basePath;
        this.teamAppsConfiguration = teamAppsConfiguration;
        this.port = port;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> SystemStarts.create().setTimestamp(Instant.now()).setType(Type.STOP).save()));
    }

    public void setSessionHandlerJar(File jarFile) throws Exception {
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jarFile.toURI().toURL()}){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                return super.findClass(name);
            }
        };
        this.sessionHandler = this.loadSessionHandler(classLoader);
    }

    private SessionHandler loadSessionHandler(URLClassLoader classLoader) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ClassGraph classGraph = new ClassGraph();
        if (classLoader != null) {
            classGraph.overrideClassLoaders(new ClassLoader[]{classLoader});
        }
        ClassInfoList classInfos = classGraph.enableAllInfo().scan().getClassesImplementing(SessionHandler.class.getName()).getStandardClasses();
        Class builder = ((ClassInfo)classInfos.get(0)).loadClass();
        return (SessionHandler)builder.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void onSessionStart(SessionContext context) {
        this.sessionHandler.handleSessionStart(context);
    }

    @Override
    public void updateSessionHandler(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public void start() throws Exception {
        File dbPath = new File(this.basePath, "db");
        dbPath.mkdir();
        this.universalDb = UniversalDB.createStandalone((File)dbPath, (SchemaInfoProvider)new SchemaInfo());
        if (this.sessionHandler == null) {
            this.sessionHandler = this.loadSessionHandler(null);
        }
        this.sessionHandler.init(this, this.universalDb);
        TeamAppsUndertowEmbeddedServer server = new TeamAppsUndertowEmbeddedServer((WebController)this, this.teamAppsConfiguration, this.port);
        for (final ServletRegistration servletRegistration : this.servletRegistrations) {
            for (final String mapping : servletRegistration.getMappings()) {
                LOGGER.info("Registering servlet on url path: " + mapping);
                server.addServletContextListener(new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                        ServletRegistration.Dynamic dynamic = sce.getServletContext().addServlet("teamapps-registered-" + servletRegistration.getServlet().getClass().getSimpleName() + UUID.randomUUID().toString(), servletRegistration.getServlet());
                        dynamic.setAsyncSupported(servletRegistration.isAsyncSupported());
                        dynamic.addMapping(new String[]{mapping});
                    }
                });
            }
        }
        server.start();
        SystemStarts.create().setTimestamp(Instant.now()).setType(Type.START).save();
    }

    public void addClassPathResourceProvider(String basePackage, String prefix) {
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet((ResourceProvider)new ClassPathResourceProvider(basePackage)), (String)prefix + "*"));
    }

    public void addServletRegistration(ServletRegistration servletRegistration) {
        this.servletRegistrations.add(servletRegistration);
    }
}

