/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.application.theme;

import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.teamapps.application.api.application.theme.ApplicationTheme;
import org.teamapps.application.api.application.theme.ApplicationThemeImpl;
import org.teamapps.application.api.application.theme.CustomApplicationThemeImpl;

public class ApplicationThemeBuilder {
    private boolean darkThemePreferred;
    private CustomApplicationThemeImpl darkTheme = new CustomApplicationThemeImpl();
    private CustomApplicationThemeImpl brightTheme = new CustomApplicationThemeImpl();

    public static ApplicationThemeBuilder create() {
        return new ApplicationThemeBuilder();
    }

    public ApplicationThemeBuilder darkThemePreferred() {
        this.darkThemePreferred = true;
        return this;
    }

    public ApplicationThemeBuilder addCss(String css) {
        return this.addCss(css, true, true);
    }

    public ApplicationThemeBuilder addCss(String css, boolean dark, boolean bright) {
        if (css == null || css.isBlank()) {
            return this;
        }
        if (dark) {
            this.darkTheme.appendCss(css);
        }
        if (bright) {
            this.brightTheme.appendCss(css);
        }
        return this;
    }

    public ApplicationThemeBuilder addCssFromResource(String resourceName) {
        return this.addCssFromResource(resourceName, true, true);
    }

    public ApplicationThemeBuilder addCssFromResource(String resourceName, boolean dark, boolean bright) {
        String css = ApplicationThemeBuilder.readStringResource(resourceName);
        return this.addCss(css, dark, bright);
    }

    public ApplicationThemeBuilder addIconStyle(Class<?> iconClass, Object style) {
        return this.addIconStyle(iconClass, style, true, true);
    }

    public ApplicationThemeBuilder addIconStyle(Class<?> iconClass, Object style, boolean dark, boolean bright) {
        if (style == null || iconClass == null) {
            return this;
        }
        if (dark) {
            this.darkTheme.addIconStyle(iconClass, style);
        }
        if (bright) {
            this.brightTheme.addIconStyle(iconClass, style);
        }
        return this;
    }

    public ApplicationThemeBuilder setBackgroundImage(byte[] bytes) {
        return this.setBackgroundImage(bytes, true, true);
    }

    public ApplicationThemeBuilder setBackgroundImage(byte[] bytes, boolean dark, boolean bright) {
        if (dark) {
            this.darkTheme.setBackgroundImage(bytes);
        }
        if (bright) {
            this.brightTheme.setBackgroundImage(bytes);
        }
        return this;
    }

    public ApplicationThemeBuilder setBackgroundImage(String resourceName) {
        return this.setBackgroundImage(resourceName, true, true);
    }

    public ApplicationThemeBuilder setBackgroundImage(String resourceName, boolean dark, boolean bright) {
        byte[] bytes = ApplicationThemeBuilder.readByteArrayResource(resourceName);
        return this.setBackgroundImage(bytes, dark, bright);
    }

    public static String readStringResource(String resourceName) {
        try {
            return Resources.toString((URL)Resources.getResource((String)resourceName), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] readByteArrayResource(String resourceName) {
        try {
            return Resources.toByteArray((URL)Resources.getResource((String)resourceName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ApplicationTheme build() {
        return new ApplicationThemeImpl(this.darkThemePreferred, this.darkTheme, this.brightTheme);
    }
}

