/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.localization;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.application.api.localization.ApplicationLocalizationProvider;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.icon.flags.FlagIcon;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.model.ComboBoxModel;

public enum Country {
    AF_AFGHANISTAN("AF", "Afghanistan", (Icon)FlagIcon.AF_AFGHANISTAN),
    AX_ALAND_ISLANDS("AX", "\u00c5land Islands", (Icon)FlagIcon.AX_ALAND_ISLANDS),
    AL_ALBANIA("AL", "Albania", (Icon)FlagIcon.AL_ALBANIA),
    DZ_ALGERIA("DZ", "Algeria", (Icon)FlagIcon.DZ_ALGERIA),
    AS_AMERICAN_SAMOA("AS", "American Samoa", (Icon)FlagIcon.AS_AMERICAN_SAMOA),
    AD_ANDORRA("AD", "Andorra", (Icon)FlagIcon.AD_ANDORRA),
    AO_ANGOLA("AO", "Angola", (Icon)FlagIcon.AO_ANGOLA),
    AI_ANGUILLA("AI", "Anguilla", (Icon)FlagIcon.AI_ANGUILLA),
    AQ_ANTARCTICA("AQ", "Antarctica", (Icon)FlagIcon.AQ_ANTARCTICA),
    AG_ANTIGUA_AND_BARBUDA("AG", "Antigua and Barbuda", (Icon)FlagIcon.AG_ANTIGUA_BARBUDA),
    AR_ARGENTINA("AR", "Argentina", (Icon)FlagIcon.AR_ARGENTINA),
    AM_ARMENIA("AM", "Armenia", (Icon)FlagIcon.AM_ARMENIA),
    AW_ARUBA("AW", "Aruba", (Icon)FlagIcon.AW_ARUBA),
    AU_AUSTRALIA("AU", "Australia", (Icon)FlagIcon.AU_AUSTRALIA),
    AT_AUSTRIA("AT", "Austria", (Icon)FlagIcon.AT_AUSTRIA),
    AZ_AZERBAIJAN("AZ", "Azerbaijan", (Icon)FlagIcon.AZ_AZERBAIJAN),
    BH_BAHRAIN("BH", "Bahrain", (Icon)FlagIcon.BH_BAHRAIN),
    BS_BAHAMAS("BS", "Bahamas", (Icon)FlagIcon.BS_BAHAMAS),
    BD_BANGLADESH("BD", "Bangladesh", (Icon)FlagIcon.BD_BANGLADESH),
    BB_BARBADOS("BB", "Barbados", (Icon)FlagIcon.BB_BARBADOS),
    BY_BELARUS("BY", "Belarus", (Icon)FlagIcon.BY_BELARUS),
    BE_BELGIUM("BE", "Belgium", (Icon)FlagIcon.BE_BELGIUM),
    BZ_BELIZE("BZ", "Belize", (Icon)FlagIcon.BZ_BELIZE),
    BJ_BENIN("BJ", "Benin", (Icon)FlagIcon.BJ_BENIN),
    BM_BERMUDA("BM", "Bermuda", (Icon)FlagIcon.BM_BERMUDA),
    BT_BHUTAN("BT", "Bhutan", (Icon)FlagIcon.BT_BHUTAN),
    BO_BOLIVIA("BO", "Bolivia", (Icon)FlagIcon.BO_BOLIVIA),
    BQ_BONAIRE_SINT_EUSTATIUS_AND_SABA("BQ", "Bonaire, Sint Eustatius and Saba", (Icon)FlagIcon.BQ_CARIBBEAN_NETHERLANDS),
    BA_BOSNIA_AND_HERZEGOVINA("BA", "Bosnia and Herzegovina", (Icon)FlagIcon.BA_BOSNIA),
    BW_BOTSWANA("BW", "Botswana", (Icon)FlagIcon.BW_BOTSWANA),
    BV_BOUVET_ISLAND("BV", "Bouvet Island", (Icon)FlagIcon.BV_BOUVET_ISLAND),
    BR_BRAZIL("BR", "Brazil", (Icon)FlagIcon.BR_BRAZIL),
    IO_BRITISH_INDIAN_OCEAN_TERRITORY("IO", "British Indian Ocean Territory", (Icon)FlagIcon.IO_BRITISH_INDIAN_OCEAN_TERRITORY),
    BN_BRUNEI_DARUSSALAM("BN", "Brunei Darussalam", (Icon)FlagIcon.BN_BRUNEI),
    BG_BULGARIA("BG", "Bulgaria", (Icon)FlagIcon.BG_BULGARIA),
    BF_BURKINA_FASO("BF", "Burkina Faso", (Icon)FlagIcon.BF_BURKINA_FASO),
    BI_BURUNDI("BI", "Burundi", (Icon)FlagIcon.BI_BURUNDI),
    KH_CAMBODIA("KH", "Cambodia", (Icon)FlagIcon.KH_CAMBODIA),
    CM_CAMEROON("CM", "Cameroon", (Icon)FlagIcon.CM_CAMEROON),
    CA_CANADA("CA", "Canada", (Icon)FlagIcon.CA_CANADA),
    CV_CAPE_VERDE("CV", "Cape Verde", (Icon)FlagIcon.CV_CAPE_VERDE),
    KY_CAYMAN_ISLANDS("KY", "Cayman Islands", (Icon)FlagIcon.KY_CAYMAN_ISLANDS),
    CF_CENTRAL_AFRICAN_REPUBLIC("CF", "Central African Republic", (Icon)FlagIcon.CF_CENTRAL_AFRICAN_REPUBLIC),
    TD_CHAD("TD", "Chad", (Icon)FlagIcon.TD_CHAD),
    CL_CHILE("CL", "Chile", (Icon)FlagIcon.CL_CHILE),
    CN_CHINA("CN", "China", (Icon)FlagIcon.CN_CHINA),
    CX_CHRISTMAS_ISLAND("CX", "Christmas Island", (Icon)FlagIcon.CX_CHRISTMAS_ISLAND),
    CC_COCOS__KEELING_ISLANDS("CC", "Cocos (Keeling) Islands", (Icon)FlagIcon.CC_COCOS_ISLANDS),
    CO_COLOMBIA("CO", "Colombia", (Icon)FlagIcon.CO_COLOMBIA),
    KM_COMOROS("KM", "Comoros", (Icon)FlagIcon.KM_COMOROS),
    CG_CONGO("CG", "Congo", (Icon)FlagIcon.CG_CONGO__BRAZZAVILLE),
    CD_CONGO_THE_DEMOCRATIC_REPUBLIC_OF_THE("CD", "Congo, the Democratic Republic of the", (Icon)FlagIcon.CD_CONGO__KINSHASA),
    CK_COOK_ISLANDS("CK", "Cook Islands", (Icon)FlagIcon.CK_COOK_ISLANDS),
    CR_COSTA_RICA("CR", "Costa Rica", (Icon)FlagIcon.CR_COSTA_RICA),
    CI_COTE_D_IVOIRE("CI", "C\u00f4te d'Ivoire", (Icon)FlagIcon.CI_COTE_D_IVOIRE),
    HR_CROATIA("HR", "Croatia", (Icon)FlagIcon.HR_CROATIA),
    CU_CUBA("CU", "Cuba", (Icon)FlagIcon.CU_CUBA),
    CW_CURACAO("CW", "Cura\u00e7ao", (Icon)FlagIcon.CW_CURACAO),
    CY_CYPRUS("CY", "Cyprus", (Icon)FlagIcon.CY_CYPRUS),
    CZ_CZECH_REPUBLIC("CZ", "Czech Republic", (Icon)FlagIcon.CZ_CZECHIA),
    DK_DENMARK("DK", "Denmark", (Icon)FlagIcon.DK_DENMARK),
    DJ_DJIBOUTI("DJ", "Djibouti", (Icon)FlagIcon.DJ_DJIBOUTI),
    DM_DOMINICA("DM", "Dominica", (Icon)FlagIcon.DM_DOMINICA),
    DO_DOMINICAN_REPUBLIC("DO", "Dominican Republic", (Icon)FlagIcon.DO_DOMINICAN_REPUBLIC),
    EC_ECUADOR("EC", "Ecuador", (Icon)FlagIcon.EC_ECUADOR),
    EG_EGYPT("EG", "Egypt", (Icon)FlagIcon.EG_EGYPT),
    SV_EL_SALVADOR("SV", "El Salvador", (Icon)FlagIcon.SV_EL_SALVADOR),
    GQ_EQUATORIAL_GUINEA("GQ", "Equatorial Guinea", (Icon)FlagIcon.GQ_EQUATORIAL_GUINEA),
    ER_ERITREA("ER", "Eritrea", (Icon)FlagIcon.ER_ERITREA),
    EE_ESTONIA("EE", "Estonia", (Icon)FlagIcon.EE_ESTONIA),
    ET_ETHIOPIA("ET", "Ethiopia", (Icon)FlagIcon.ET_ETHIOPIA),
    FK_FALKLAND_ISLANDS__MALVINAS_("FK", "Falkland Islands (Malvinas)", (Icon)FlagIcon.FK_FALKLAND_ISLANDS),
    FO_FAROE_ISLANDS("FO", "Faroe Islands", (Icon)FlagIcon.FO_FAROE_ISLANDS),
    FJ_FIJI("FJ", "Fiji", (Icon)FlagIcon.FJ_FIJI),
    FI_FINLAND("FI", "Finland", (Icon)FlagIcon.FI_FINLAND),
    FR_FRANCE("FR", "France", (Icon)FlagIcon.FR_FRANCE),
    GF_FRENCH_GUIANA("GF", "French Guiana", (Icon)FlagIcon.GF_FRENCH_GUIANA),
    PF_FRENCH_POLYNESIA("PF", "French Polynesia", (Icon)FlagIcon.PF_FRENCH_POLYNESIA),
    TF_FRENCH_SOUTHERN_TERRITORIES("TF", "French Southern Territories", (Icon)FlagIcon.TF_FRENCH_SOUTHERN_TERRITORIES),
    GA_GABON("GA", "Gabon", (Icon)FlagIcon.GA_GABON),
    GM_GAMBIA("GM", "Gambia", (Icon)FlagIcon.GM_GAMBIA),
    GE_GEORGIA("GE", "Georgia", (Icon)FlagIcon.GE_GEORGIA),
    DE_GERMANY("DE", "Germany", (Icon)FlagIcon.DE_GERMANY),
    GH_GHANA("GH", "Ghana", (Icon)FlagIcon.GH_GHANA),
    GI_GIBRALTAR("GI", "Gibraltar", (Icon)FlagIcon.GI_GIBRALTAR),
    GR_GREECE("GR", "Greece", (Icon)FlagIcon.GR_GREECE),
    GL_GREENLAND("GL", "Greenland", (Icon)FlagIcon.GL_GREENLAND),
    GD_GRENADA("GD", "Grenada", (Icon)FlagIcon.GD_GRENADA),
    GP_GUADELOUPE("GP", "Guadeloupe", (Icon)FlagIcon.GP_GUADELOUPE),
    GU_GUAM("GU", "Guam", (Icon)FlagIcon.GU_GUAM),
    GT_GUATEMALA("GT", "Guatemala", (Icon)FlagIcon.GT_GUATEMALA),
    GG_GUERNSEY("GG", "Guernsey", (Icon)FlagIcon.GG_GUERNSEY),
    GN_GUINEA("GN", "Guinea", (Icon)FlagIcon.GN_GUINEA),
    GW_GUINEA_BISSAU("GW", "Guinea-Bissau", (Icon)FlagIcon.GW_GUINEA_BISSAU),
    GY_GUYANA("GY", "Guyana", (Icon)FlagIcon.GY_GUYANA),
    HT_HAITI("HT", "Haiti", (Icon)FlagIcon.HT_HAITI),
    HM_HEARD_ISLAND_AND_MC_DONALD_ISLANDS("HM", "Heard Island and McDonald Islands", (Icon)FlagIcon.HM_HEARD_MCDONALD_ISLANDS),
    VA_VATICAN_CITY_STATE("VA", "Vatican City State", (Icon)FlagIcon.VA_VATICAN_CITY),
    HN_HONDURAS("HN", "Honduras", (Icon)FlagIcon.HN_HONDURAS),
    HK_HONG_KONG("HK", "Hong Kong", (Icon)FlagIcon.HK_HONG_KONG),
    HU_HUNGARY("HU", "Hungary", (Icon)FlagIcon.HU_HUNGARY),
    IS_ICELAND("IS", "Iceland", (Icon)FlagIcon.IS_ICELAND),
    IN_INDIA("IN", "India", (Icon)FlagIcon.IN_INDIA),
    ID_INDONESIA("ID", "Indonesia", (Icon)FlagIcon.ID_INDONESIA),
    IR_IRAN("IR", "Iran", (Icon)FlagIcon.IR_IRAN),
    IQ_IRAQ("IQ", "Iraq", (Icon)FlagIcon.IQ_IRAQ),
    IE_IRELAND("IE", "Ireland", (Icon)FlagIcon.IE_IRELAND),
    IM_ISLE_OF_MAN("IM", "Isle of Man", (Icon)FlagIcon.IM_ISLE_OF_MAN),
    IL_ISRAEL("IL", "Israel", (Icon)FlagIcon.IL_ISRAEL),
    IT_ITALY("IT", "Italy", (Icon)FlagIcon.IT_ITALY),
    JM_JAMAICA("JM", "Jamaica", (Icon)FlagIcon.JM_JAMAICA),
    JP_JAPAN("JP", "Japan", (Icon)FlagIcon.JP_JAPAN),
    JE_JERSEY("JE", "Jersey", (Icon)FlagIcon.JE_JERSEY),
    JO_JORDAN("JO", "Jordan", (Icon)FlagIcon.JO_JORDAN),
    KZ_KAZAKHSTAN("KZ", "Kazakhstan", (Icon)FlagIcon.KZ_KAZAKHSTAN),
    KE_KENYA("KE", "Kenya", (Icon)FlagIcon.KE_KENYA),
    KI_KIRIBATI("KI", "Kiribati", (Icon)FlagIcon.KI_KIRIBATI),
    KP_KOREA_DEMOCRATIC_PEOPLE_S_REPUBLIC_OF("KP", "Korea, Democratic People's Republic of", (Icon)FlagIcon.KP_NORTH_KOREA),
    KR_KOREA_REPUBLIC_OF("KR", "Korea, Republic of", (Icon)FlagIcon.KR_SOUTH_KOREA),
    KW_KUWAIT("KW", "Kuwait", (Icon)FlagIcon.KW_KUWAIT),
    KG_KYRGYZSTAN("KG", "Kyrgyzstan", (Icon)FlagIcon.KG_KYRGYZSTAN),
    LA_LAO_PEOPLE_S_DEMOCRATIC_REPUBLIC("LA", "Lao People's Democratic Republic", (Icon)FlagIcon.LA_LAOS),
    LV_LATVIA("LV", "Latvia", (Icon)FlagIcon.LV_LATVIA),
    LB_LEBANON("LB", "Lebanon", (Icon)FlagIcon.LB_LEBANON),
    LS_LESOTHO("LS", "Lesotho", (Icon)FlagIcon.LS_LESOTHO),
    LR_LIBERIA("LR", "Liberia", (Icon)FlagIcon.LR_LIBERIA),
    LY_LIBYA("LY", "Libya", (Icon)FlagIcon.LY_LIBYA),
    LI_LIECHTENSTEIN("LI", "Liechtenstein", (Icon)FlagIcon.LI_LIECHTENSTEIN),
    LT_LITHUANIA("LT", "Lithuania", (Icon)FlagIcon.LT_LITHUANIA),
    LU_LUXEMBOURG("LU", "Luxembourg", (Icon)FlagIcon.LU_LUXEMBOURG),
    MO_MACAO("MO", "Macao", (Icon)FlagIcon.MO_MACAU),
    MK_MACEDONIA_THE_FORMER_YUGOSLAV_REPUBLIC_OF("MK", "Macedonia, the Former Yugoslav Republic of", (Icon)FlagIcon.MK_MACEDONIA),
    MG_MADAGASCAR("MG", "Madagascar", (Icon)FlagIcon.MG_MADAGASCAR),
    MW_MALAWI("MW", "Malawi", (Icon)FlagIcon.MW_MALAWI),
    MY_MALAYSIA("MY", "Malaysia", (Icon)FlagIcon.MY_MALAYSIA),
    MV_MALDIVES("MV", "Maldives", (Icon)FlagIcon.MV_MALDIVES),
    ML_MALI("ML", "Mali", (Icon)FlagIcon.ML_MALI),
    MT_MALTA("MT", "Malta", (Icon)FlagIcon.MT_MALTA),
    MH_MARSHALL_ISLANDS("MH", "Marshall Islands", (Icon)FlagIcon.MH_MARSHALL_ISLANDS),
    MQ_MARTINIQUE("MQ", "Martinique", (Icon)FlagIcon.MQ_MARTINIQUE),
    MR_MAURITANIA("MR", "Mauritania", (Icon)FlagIcon.MR_MAURITANIA),
    MU_MAURITIUS("MU", "Mauritius", (Icon)FlagIcon.MU_MAURITIUS),
    YT_MAYOTTE("YT", "Mayotte", (Icon)FlagIcon.YT_MAYOTTE),
    MX_MEXICO("MX", "Mexico", (Icon)FlagIcon.MX_MEXICO),
    FM_MICRONESIA("FM", "Micronesia", (Icon)FlagIcon.FM_MICRONESIA),
    MD_MOLDOVA("MD", "Moldova", (Icon)FlagIcon.MD_MOLDOVA),
    MC_MONACO("MC", "Monaco", (Icon)FlagIcon.MC_MONACO),
    MN_MONGOLIA("MN", "Mongolia", (Icon)FlagIcon.MN_MONGOLIA),
    ME_MONTENEGRO("ME", "Montenegro", (Icon)FlagIcon.ME_MONTENEGRO),
    MS_MONTSERRAT("MS", "Montserrat", (Icon)FlagIcon.MS_MONTSERRAT),
    MA_MOROCCO("MA", "Morocco", (Icon)FlagIcon.MA_MOROCCO),
    MZ_MOZAMBIQUE("MZ", "Mozambique", (Icon)FlagIcon.MZ_MOZAMBIQUE),
    MM_MYANMAR("MM", "Myanmar", (Icon)FlagIcon.MM_MYANMAR),
    NA_NAMIBIA("NA", "Namibia", (Icon)FlagIcon.NA_NAMIBIA),
    NR_NAURU("NR", "Nauru", (Icon)FlagIcon.NR_NAURU),
    NP_NEPAL("NP", "Nepal", (Icon)FlagIcon.NP_NEPAL),
    NL_NETHERLANDS("NL", "Netherlands", (Icon)FlagIcon.NL_NETHERLANDS),
    NC_NEW_CALEDONIA("NC", "New Caledonia", (Icon)FlagIcon.NC_NEW_CALEDONIA),
    NZ_NEW_ZEALAND("NZ", "New Zealand", (Icon)FlagIcon.NZ_NEW_ZEALAND),
    NI_NICARAGUA("NI", "Nicaragua", (Icon)FlagIcon.NI_NICARAGUA),
    NE_NIGER("NE", "Niger", (Icon)FlagIcon.NE_NIGER),
    NG_NIGERIA("NG", "Nigeria", (Icon)FlagIcon.NG_NIGERIA),
    NU_NIUE("NU", "Niue", (Icon)FlagIcon.NU_NIUE),
    NF_NORFOLK_ISLAND("NF", "Norfolk Island", (Icon)FlagIcon.NF_NORFOLK_ISLAND),
    MP_NORTHERN_MARIANA_ISLANDS("MP", "Northern Mariana Islands", (Icon)FlagIcon.MP_NORTHERN_MARIANA_ISLANDS),
    NO_NORWAY("NO", "Norway", (Icon)FlagIcon.NO_NORWAY),
    OM_OMAN("OM", "Oman", (Icon)FlagIcon.OM_OMAN),
    PK_PAKISTAN("PK", "Pakistan", (Icon)FlagIcon.PK_PAKISTAN),
    PW_PALAU("PW", "Palau", (Icon)FlagIcon.PW_PALAU),
    PS_PALESTINE_STATE_OF("PS", "Palestine, State of", (Icon)FlagIcon.PS_PALESTINE),
    PA_PANAMA("PA", "Panama", (Icon)FlagIcon.PA_PANAMA),
    PG_PAPUA_NEW_GUINEA("PG", "Papua New Guinea", (Icon)FlagIcon.PG_PAPUA_NEW_GUINEA),
    PY_PARAGUAY("PY", "Paraguay", (Icon)FlagIcon.PY_PARAGUAY),
    PE_PERU("PE", "Peru", (Icon)FlagIcon.PE_PERU),
    PH_PHILIPPINES("PH", "Philippines", (Icon)FlagIcon.PH_PHILIPPINES),
    PN_PITCAIRN("PN", "Pitcairn", (Icon)FlagIcon.PN_PITCAIRN_ISLANDS),
    PL_POLAND("PL", "Poland", (Icon)FlagIcon.PL_POLAND),
    PT_PORTUGAL("PT", "Portugal", (Icon)FlagIcon.PT_PORTUGAL),
    PR_PUERTO_RICO("PR", "Puerto Rico", (Icon)FlagIcon.PR_PUERTO_RICO),
    QA_QATAR("QA", "Qatar", (Icon)FlagIcon.QA_QATAR),
    RE_REUNION("RE", "R\u00e9union", (Icon)FlagIcon.RE_REUNION),
    RO_ROMANIA("RO", "Romania", (Icon)FlagIcon.RO_ROMANIA),
    RU_RUSSIAN_FEDERATION("RU", "Russian Federation", (Icon)FlagIcon.RU_RUSSIA),
    RW_RWANDA("RW", "Rwanda", (Icon)FlagIcon.RW_RWANDA),
    BL_SAINT_BARTHELEMY("BL", "Saint Barth\u00e9lemy", (Icon)FlagIcon.BL_ST_BARTHELEMY),
    SH_SAINT_HELENA_ASCENSION_AND_TRISTAN_DA_CUNHA("SH", "Saint Helena, Ascension and Tristan da Cunha", (Icon)FlagIcon.SH_ST_HELENA),
    KN_SAINT_KITTS_AND_NEVIS("KN", "Saint Kitts and Nevis", (Icon)FlagIcon.KN_ST_KITTS_NEVIS),
    LC_SAINT_LUCIA("LC", "Saint Lucia", (Icon)FlagIcon.LC_ST_LUCIA),
    MF_SAINT_MARTIN__FRENCH_PART_("MF", "Saint Martin (French part)", (Icon)FlagIcon.MF_ST_MARTIN),
    PM_SAINT_PIERRE_AND_MIQUELON("PM", "Saint Pierre and Miquelon", (Icon)FlagIcon.PM_ST_PIERRE_MIQUELON),
    VC_SAINT_VINCENT_AND_THE_GRENADINES("VC", "Saint Vincent and the Grenadines", (Icon)FlagIcon.VC_ST_VINCENT_GRENADINES),
    WS_SAMOA("WS", "Samoa", (Icon)FlagIcon.WS_SAMOA),
    SM_SAN_MARINO("SM", "San Marino", (Icon)FlagIcon.SM_SAN_MARINO),
    ST_SAO_TOME_AND_PRINCIPE("ST", "Sao Tome and Principe", (Icon)FlagIcon.ST_SAO_TOME_PRINCIPE),
    SA_SAUDI_ARABIA("SA", "Saudi Arabia", (Icon)FlagIcon.SA_SAUDI_ARABIA),
    SN_SENEGAL("SN", "Senegal", (Icon)FlagIcon.SN_SENEGAL),
    RS_SERBIA("RS", "Serbia", (Icon)FlagIcon.RS_SERBIA),
    SC_SEYCHELLES("SC", "Seychelles", (Icon)FlagIcon.SC_SEYCHELLES),
    SL_SIERRA_LEONE("SL", "Sierra Leone", (Icon)FlagIcon.SL_SIERRA_LEONE),
    SG_SINGAPORE("SG", "Singapore", (Icon)FlagIcon.SG_SINGAPORE),
    SX_SINT_MAARTEN__DUTCH_PART_("SX", "Sint Maarten (Dutch part)", (Icon)FlagIcon.SX_SINT_MAARTEN),
    SK_SLOVAKIA("SK", "Slovakia", (Icon)FlagIcon.SK_SLOVAKIA),
    SI_SLOVENIA("SI", "Slovenia", (Icon)FlagIcon.SI_SLOVENIA),
    SB_SOLOMON_ISLANDS("SB", "Solomon Islands", (Icon)FlagIcon.SB_SOLOMON_ISLANDS),
    SO_SOMALIA("SO", "Somalia", (Icon)FlagIcon.SO_SOMALIA),
    ZA_SOUTH_AFRICA("ZA", "South Africa", (Icon)FlagIcon.ZA_SOUTH_AFRICA),
    GS_SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS("GS", "South Georgia and the South Sandwich Islands", (Icon)FlagIcon.GS_SOUTH_GEORGIA_SOUTH_SANDWICH_ISLANDS),
    SS_SOUTH_SUDAN("SS", "South Sudan", (Icon)FlagIcon.SS_SOUTH_SUDAN),
    ES_SPAIN("ES", "Spain", (Icon)FlagIcon.ES_SPAIN),
    LK_SRI_LANKA("LK", "Sri Lanka", (Icon)FlagIcon.LK_SRI_LANKA),
    SD_SUDAN("SD", "Sudan", (Icon)FlagIcon.SD_SUDAN),
    SR_SURINAME("SR", "Suriname", (Icon)FlagIcon.SR_SURINAME),
    SJ_SVALBARD_AND_JAN_MAYEN("SJ", "Svalbard and Jan Mayen", (Icon)FlagIcon.SJ_SVALBARD_JAN_MAYEN),
    SZ_SWAZILAND("SZ", "Swaziland", (Icon)FlagIcon.SZ_SWAZILAND),
    SE_SWEDEN("SE", "Sweden", (Icon)FlagIcon.SE_SWEDEN),
    CH_SWITZERLAND("CH", "Switzerland", (Icon)FlagIcon.CH_SWITZERLAND),
    SY_SYRIAN_ARAB_REPUBLIC("SY", "Syrian Arab Republic", (Icon)FlagIcon.SY_SYRIA),
    TW_TAIWAN("TW", "Taiwan", (Icon)FlagIcon.TW_TAIWAN),
    TJ_TAJIKISTAN("TJ", "Tajikistan", (Icon)FlagIcon.TJ_TAJIKISTAN),
    TZ_TANZANIA("TZ", "Tanzania", (Icon)FlagIcon.TZ_TANZANIA),
    TH_THAILAND("TH", "Thailand", (Icon)FlagIcon.TH_THAILAND),
    TL_TIMOR_LESTE("TL", "Timor-Leste", (Icon)FlagIcon.TL_TIMOR_LESTE),
    TG_TOGO("TG", "Togo", (Icon)FlagIcon.TG_TOGO),
    TK_TOKELAU("TK", "Tokelau", (Icon)FlagIcon.TK_TOKELAU),
    TO_TONGA("TO", "Tonga", (Icon)FlagIcon.TO_TONGA),
    TT_TRINIDAD_AND_TOBAGO("TT", "Trinidad and Tobago", (Icon)FlagIcon.TT_TRINIDAD_TOBAGO),
    TN_TUNISIA("TN", "Tunisia", (Icon)FlagIcon.TN_TUNISIA),
    TR_TURKEY("TR", "Turkey", (Icon)FlagIcon.TR_TURKEY),
    TM_TURKMENISTAN("TM", "Turkmenistan", (Icon)FlagIcon.TM_TURKMENISTAN),
    TC_TURKS_AND_CAICOS_ISLANDS("TC", "Turks and Caicos Islands", (Icon)FlagIcon.TC_TURKS_CAICOS_ISLANDS),
    TV_TUVALU("TV", "Tuvalu", (Icon)FlagIcon.TV_TUVALU),
    UG_UGANDA("UG", "Uganda", (Icon)FlagIcon.UG_UGANDA),
    UA_UKRAINE("UA", "Ukraine", (Icon)FlagIcon.UA_UKRAINE),
    AE_UNITED_ARAB_EMIRATES("AE", "United Arab Emirates", (Icon)FlagIcon.AE_UNITED_ARAB_EMIRATES),
    GB_UNITED_KINGDOM("GB", "United Kingdom", (Icon)FlagIcon.GB_GREAT_BRITAIN),
    US_UNITED_STATES("US", "United States", (Icon)FlagIcon.US_UNITED_STATES),
    UM_UNITED_STATES_MINOR_OUTLYING_ISLANDS("UM", "United States Minor Outlying Islands", (Icon)FlagIcon.UM_US_OUTLYING_ISLANDS),
    UY_URUGUAY("UY", "Uruguay", (Icon)FlagIcon.UY_URUGUAY),
    UZ_UZBEKISTAN("UZ", "Uzbekistan", (Icon)FlagIcon.UZ_UZBEKISTAN),
    VU_VANUATU("VU", "Vanuatu", (Icon)FlagIcon.VU_VANUATU),
    VE_VENEZUELA("VE", "Venezuela", (Icon)FlagIcon.VE_VENEZUELA),
    VN_VIETNAM("VN", "Vietnam", (Icon)FlagIcon.VN_VIETNAM),
    VG_VIRGIN_ISLANDS_BRITISH("VG", "Virgin Islands, British", (Icon)FlagIcon.VG_BRITISH_VIRGIN_ISLANDS),
    VI_VIRGIN_ISLANDS_U_S("VI", "Virgin Islands, U.S.", (Icon)FlagIcon.VI_US_VIRGIN_ISLANDS),
    WF_WALLIS_AND_FUTUNA("WF", "Wallis and Futuna", (Icon)FlagIcon.WF_WALLIS_FUTUNA),
    EH_WESTERN_SAHARA("EH", "Western Sahara", (Icon)FlagIcon.EH_WESTERN_SAHARA),
    YE_YEMEN("YE", "Yemen", (Icon)FlagIcon.YE_YEMEN),
    ZM_ZAMBIA("ZM", "Zambia", (Icon)FlagIcon.ZM_ZAMBIA),
    ZW_ZIMBABWE("ZW", "Zimbabwe", (Icon)FlagIcon.ZW_ZIMBABWE),
    XK_KOSOVO("XK", "Kosovo", (Icon)FlagIcon.XK_KOSOVO);

    private static final Map<String, Country> entryByCountryIsoCode;
    private final String isoCode;
    private final String value;
    private final Icon icon;

    public static Country getCountryByIsoCode(String countryIso) {
        return entryByCountryIsoCode.get(countryIso);
    }

    private Country(String isoCode, String value, Icon icon) {
        this.isoCode = isoCode;
        this.value = value;
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public String getValue() {
        return this.value;
    }

    public String getKey() {
        return "org.teamapps.dictionary.country." + this.name();
    }

    public String getLocalized(ApplicationLocalizationProvider localizationProvider) {
        return localizationProvider.getLocalized(this.getKey(), new Object[0]);
    }

    private boolean matchCountry(String query, ApplicationLocalizationProvider localizationProvider) {
        query = query.toLowerCase();
        String localized = this.getLocalized(localizationProvider);
        return localized != null && localized.toLowerCase().contains(query) || query.equals(this.getIsoCode().toLowerCase());
    }

    public static PropertyExtractor<Country> getPropertyExtractor(ApplicationLocalizationProvider localizationProvider) {
        return (country, s) -> {
            switch (s) {
                case "icon": {
                    return country.getIcon();
                }
                case "caption": {
                    return country.getLocalized(localizationProvider);
                }
                case "description": {
                    return country.getIsoCode();
                }
            }
            return null;
        };
    }

    public static ComboBox<Country> createComboBox(ApplicationLocalizationProvider localizationProvider) {
        ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        comboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_TWO_LINES);
        List<Country> countries = Arrays.asList(Country.values());
        comboBox.setModel(Country.getCountryComboBoxModel(localizationProvider, countries));
        comboBox.setPropertyExtractor(Country.getPropertyExtractor(localizationProvider));
        comboBox.setRecordToStringFunction(country -> country.getLocalized(localizationProvider));
        return comboBox;
    }

    public static TagComboBox<Country> createTagComboBox(ApplicationLocalizationProvider localizationProvider) {
        TagComboBox tagComboBox = new TagComboBox();
        tagComboBox.setTemplate((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        tagComboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_TWO_LINES);
        List<Country> countries = Arrays.asList(Country.values());
        tagComboBox.setModel(Country.getCountryComboBoxModel(localizationProvider, countries));
        tagComboBox.setPropertyExtractor(Country.getPropertyExtractor(localizationProvider));
        tagComboBox.setRecordToStringFunction(country -> country.getLocalized(localizationProvider));
        return tagComboBox;
    }

    private static ComboBoxModel<Country> getCountryComboBoxModel(ApplicationLocalizationProvider localizationProvider, List<Country> countries) {
        return s -> {
            if (s == null || s.isBlank()) {
                return countries;
            }
            String query = s.toLowerCase();
            return countries.stream().filter(language -> language.matchCountry(query, localizationProvider)).collect(Collectors.toList());
        };
    }

    static {
        entryByCountryIsoCode = new HashMap<String, Country>();
        for (Country value : Country.values()) {
            entryByCountryIsoCode.put(value.getIsoCode(), value);
        }
    }
}

