/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.privilege;

import java.util.List;
import org.teamapps.application.api.privilege.CustomObjectPrivilegeGroup;
import org.teamapps.application.api.privilege.OrganizationalPrivilegeGroup;
import org.teamapps.application.api.privilege.Privilege;
import org.teamapps.application.api.privilege.PrivilegeObject;
import org.teamapps.application.api.privilege.RoleAssignmentDelegatedCustomPrivilegeGroup;
import org.teamapps.application.api.privilege.SimpleCustomObjectPrivilege;
import org.teamapps.application.api.privilege.SimpleOrganizationalPrivilege;
import org.teamapps.application.api.privilege.SimplePrivilege;
import org.teamapps.application.api.privilege.StandardPrivilegeGroup;
import org.teamapps.model.controlcenter.OrganizationUnitView;

public interface ApplicationPrivilegeProvider {
    public boolean isAllowed(SimplePrivilege var1);

    public boolean isAllowed(SimpleOrganizationalPrivilege var1, OrganizationUnitView var2);

    public boolean isAllowed(SimpleCustomObjectPrivilege var1, PrivilegeObject var2);

    public boolean isAllowed(StandardPrivilegeGroup var1, Privilege var2);

    public boolean isAllowed(OrganizationalPrivilegeGroup var1, Privilege var2, OrganizationUnitView var3);

    public boolean isAllowed(CustomObjectPrivilegeGroup var1, Privilege var2, PrivilegeObject var3);

    public boolean isAllowed(RoleAssignmentDelegatedCustomPrivilegeGroup var1, Privilege var2, PrivilegeObject var3);

    default public boolean isAnyReadAccess(OrganizationalPrivilegeGroup privilegeGroup) {
        return this.isAnyAccess(privilegeGroup, Privilege.READ);
    }

    default public boolean isAnyAccess(OrganizationalPrivilegeGroup privilegeGroup, Privilege privilege) {
        return !this.getAllowedUnits(privilegeGroup, privilege).isEmpty();
    }

    default public boolean isAnyAccess(OrganizationalPrivilegeGroup privilegeGroup, Privilege ... privileges) {
        for (Privilege privilege : privileges) {
            if (this.getAllowedUnits(privilegeGroup, privilege).isEmpty()) continue;
            return true;
        }
        return false;
    }

    default public boolean isReadAccess(StandardPrivilegeGroup privilegeGroup) {
        return this.isAllowed(privilegeGroup, Privilege.READ);
    }

    public List<OrganizationUnitView> getAllowedUnits(SimpleOrganizationalPrivilege var1);

    public List<OrganizationUnitView> getAllowedUnits(OrganizationalPrivilegeGroup var1, Privilege var2);

    public List<PrivilegeObject> getAllowedPrivilegeObjects(SimpleCustomObjectPrivilege var1);

    public List<PrivilegeObject> getAllowedPrivilegeObjects(CustomObjectPrivilegeGroup var1, Privilege var2);

    public List<PrivilegeObject> getAllowedPrivilegeObjects(RoleAssignmentDelegatedCustomPrivilegeGroup var1, Privilege var2);
}

