/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.tools;

import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ChangeCounter {
    private long time = System.currentTimeMillis();
    private Map<String, Integer> createCountMap = new HashMap<String, Integer>();
    private Map<String, Integer> updateCountMap = new HashMap<String, Integer>();
    private Map<String, Integer> deleteCountMap = new HashMap<String, Integer>();
    private Map<String, Integer> errorCountMap = new HashMap<String, Integer>();
    private String defaultRecord = "records";

    public ChangeCounter() {
    }

    public ChangeCounter(String defaultRecord) {
        this.defaultRecord = defaultRecord;
    }

    public void updateOrCreate(boolean update) {
        this.updateOrCreate(this.defaultRecord, update);
    }

    public void updateOrCreate(String name, boolean update) {
        if (update) {
            this.update(name);
        } else {
            this.create(name);
        }
    }

    public void update() {
        this.update(this.defaultRecord);
    }

    public void update(String name) {
        this.updateCountMap.compute(name, (k, v) -> v == null ? 1 : v + 1);
    }

    public void create() {
        this.create(this.defaultRecord);
    }

    public void create(String name) {
        this.createCountMap.compute(name, (k, v) -> v == null ? 1 : v + 1);
    }

    public void delete() {
        this.delete(this.defaultRecord);
    }

    public void delete(String name) {
        this.deleteCountMap.compute(name, (k, v) -> v == null ? 1 : v + 1);
    }

    public void error() {
        this.error(this.defaultRecord);
    }

    public void error(String name) {
        this.errorCountMap.compute(name, (k, v) -> v == null ? 1 : v + 1);
    }

    public int getUpdated() {
        return this.updateCountMap.getOrDefault(this.defaultRecord, 0);
    }

    public int getCreated() {
        return this.createCountMap.getOrDefault(this.defaultRecord, 0);
    }

    public int getDeleted() {
        return this.createCountMap.getOrDefault(this.defaultRecord, 0);
    }

    public int getError() {
        return this.createCountMap.getOrDefault(this.defaultRecord, 0);
    }

    public int getUpdated(String key) {
        return this.updateCountMap.getOrDefault(key, 0);
    }

    public int getCreated(String key) {
        return this.createCountMap.getOrDefault(key, 0);
    }

    public int getDeleted(String key) {
        return this.createCountMap.getOrDefault(key, 0);
    }

    public int getError(String key) {
        return this.createCountMap.getOrDefault(key, 0);
    }

    public String getDurationAsString() {
        return Duration.ofMillis(System.currentTimeMillis() - this.time).toString().substring(2);
    }

    public int getDuration() {
        return (int)(System.currentTimeMillis() - this.time);
    }

    public String getResults() {
        return this.getTime() + ", " + this.getKeys().stream().map(this::getResult).collect(Collectors.joining(", "));
    }

    public String getResults(String delimiter) {
        return this.getTime() + delimiter + this.getKeys().stream().map(this::getResult).collect(Collectors.joining(delimiter));
    }

    public String getCompactResults() {
        return this.getTime() + ", " + this.getKeys().stream().map(this::getCompactResult).collect(Collectors.joining(", "));
    }

    private String getCompactResult(String key) {
        return key + "(+" + String.valueOf(this.createCountMap.getOrDefault(key, 0)) + ", -" + String.valueOf(this.deleteCountMap.getOrDefault(key, 0)) + ", *" + String.valueOf(this.updateCountMap.getOrDefault(key, 0)) + (String)(this.errorCountMap.get(key) != null ? ", \u26a0" + String.valueOf(this.errorCountMap.get(key)) : "") + ")";
    }

    private String getResult(String key) {
        return key + "(added: " + String.valueOf(this.createCountMap.getOrDefault(key, 0)) + ", removed: " + String.valueOf(this.deleteCountMap.getOrDefault(key, 0)) + ", changed: " + String.valueOf(this.updateCountMap.getOrDefault(key, 0)) + (String)(this.errorCountMap.get(key) != null ? ", errors: " + String.valueOf(this.errorCountMap.get(key)) : "") + ")";
    }

    private String getTime() {
        return "time: " + (System.currentTimeMillis() - this.time);
    }

    public List<String> getKeys() {
        HashSet<String> set = new HashSet<String>();
        set.addAll(this.createCountMap.keySet());
        set.addAll(this.updateCountMap.keySet());
        set.addAll(this.deleteCountMap.keySet());
        set.addAll(this.errorCountMap.keySet());
        return set.stream().sorted().collect(Collectors.toList());
    }
}

