/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.ux.window;

import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.event.Event;
import org.teamapps.icons.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.Button;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormConfigurationTemplate;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.SizingPolicy;
import org.teamapps.ux.component.format.Spacing;
import org.teamapps.ux.component.grid.layout.GridColumn;
import org.teamapps.ux.component.grid.layout.GridRow;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.BaseTemplateRecord;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.window.Window;

public class BaseDialogue
extends Window {
    public Event<Boolean> onResult = new Event();
    private final ComboBox<BaseTemplateRecord<?>> comboBox;
    private final Button<?> okButton;
    private final Button<?> cancelButton;

    public static Event<Boolean> showOkCancel(Icon icon, String title, String text, ApplicationInstanceData applicationInstanceData) {
        return BaseDialogue.showOkCancel(new BaseTemplateRecord(icon, title, text), applicationInstanceData);
    }

    public static Event<Boolean> showOkCancel(BaseTemplateRecord<?> record, ApplicationInstanceData applicationInstanceData) {
        BaseDialogue dialogue = new BaseDialogue(applicationInstanceData);
        dialogue.setValues(record);
        dialogue.setIcon(record.getIcon());
        dialogue.setTitle(record.getCaption());
        dialogue.setModal(true);
        dialogue.show(250);
        return dialogue.onResult;
    }

    public static BaseDialogue createOkCancel(Icon icon, String title, ApplicationInstanceData applicationInstanceData) {
        return BaseDialogue.createOkCancel(icon, title, title, applicationInstanceData);
    }

    public static BaseDialogue createOkCancel(Icon icon, String title, String text, ApplicationInstanceData applicationInstanceData) {
        BaseDialogue dialogue = new BaseDialogue(applicationInstanceData);
        dialogue.setValues(icon, title, text);
        dialogue.setIcon(icon);
        dialogue.setTitle(title);
        dialogue.setModal(true);
        return dialogue;
    }

    public static Event<Boolean> showOk(Icon icon, String title, ApplicationInstanceData applicationInstanceData) {
        return BaseDialogue.showOk(icon, title, title, applicationInstanceData);
    }

    public static Event<Boolean> showOk(Icon icon, String title, String text, ApplicationInstanceData applicationInstanceData) {
        return BaseDialogue.showOk(icon, title, text, ApplicationIcons.OK, applicationInstanceData.getLocalized("org.teamapps.dictionary.oK", new Object[0]), applicationInstanceData);
    }

    public static Event<Boolean> showOk(Icon icon, String title, String text, Icon okButtonIcon, String okButtonCaption, ApplicationInstanceData applicationInstanceData) {
        BaseDialogue dialogue = new BaseDialogue(okButtonIcon, okButtonCaption, applicationInstanceData);
        dialogue.getCancelButton().setVisible(false);
        dialogue.setValues(icon, title, text);
        dialogue.setIcon(icon);
        dialogue.setTitle(title);
        dialogue.setModal(false);
        dialogue.show(250);
        return dialogue.onResult;
    }

    public BaseDialogue(ApplicationInstanceData applicationInstanceData) {
        this(ApplicationIcons.OK, applicationInstanceData.getLocalized("org.teamapps.dictionary.oK", new Object[0]), ApplicationIcons.WINDOW_CLOSE, applicationInstanceData.getLocalized("org.teamapps.dictionary.cancel", new Object[0]));
    }

    public BaseDialogue(Icon okButtonIcon, String okButtonCaption, ApplicationInstanceData applicationInstanceData) {
        this(okButtonIcon, okButtonCaption, ApplicationIcons.WINDOW_CLOSE, applicationInstanceData.getLocalized("org.teamapps.dictionary.cancel", new Object[0]));
    }

    public BaseDialogue(Icon okButtonIcon, String okButtonCaption, Icon cancelButtonIcon, String cancelButtonCaption) {
        ResponsiveFormConfigurationTemplate template = new ResponsiveFormConfigurationTemplate();
        template.setRowTemplate(new GridRow().setHeightPolicy(SizingPolicy.AUTO));
        template.setColumnTemplate(new GridColumn(SizingPolicy.AUTO));
        ResponsiveForm responsiveForm = new ResponsiveForm(template);
        this.setContent((Component)responsiveForm);
        this.setWidth(500);
        this.setHeight(200);
        ResponsiveFormLayout formLayout = responsiveForm.addResponsiveFormLayout(200);
        formLayout.addSection().setDrawHeaderLine(false).setMargin(new Spacing(10)).setGridGap(20);
        this.comboBox = new ComboBox();
        this.comboBox.setTemplate((Template)BaseTemplate.LIST_ITEM_VERY_LARGE_ICON_TWO_LINES);
        this.comboBox.setEditingMode(FieldEditingMode.READONLY);
        formLayout.addField(0, 0, "data", this.comboBox).setHorizontalAlignment(HorizontalElementAlignment.CENTER).setColSpan(3);
        this.okButton = Button.create((Icon)okButtonIcon, (String)okButtonCaption);
        this.okButton.onClicked.addListener(() -> {
            this.close(250);
            this.onResult.fire((Object)true);
        });
        this.cancelButton = Button.create((Icon)cancelButtonIcon, (String)cancelButtonCaption);
        this.cancelButton.onClicked.addListener(() -> {
            this.close(250);
            this.onResult.fire((Object)false);
        });
        formLayout.addComponent(1, 1, this.okButton);
        formLayout.addComponent(1, 2, this.cancelButton);
    }

    public void setValues(BaseTemplateRecord<?> record) {
        this.comboBox.setValue(record);
    }

    public void setValues(Icon icon, String title, String text) {
        this.comboBox.setValue((Object)new BaseTemplateRecord(icon, title, text));
    }

    public ComboBox<BaseTemplateRecord<?>> getComboBox() {
        return this.comboBox;
    }

    public Button<?> getOkButton() {
        return this.okButton;
    }

    public Button<?> getCancelButton() {
        return this.cancelButton;
    }
}

