/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.privilege;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.icons.Icon;

public class ApplicationRoleImpl
implements ApplicationRole {
    private final String name;
    private final Icon icon;
    private final String titleKey;
    private final String descriptionKey;
    private List<PrivilegeGroup> privilegeGroups;

    public ApplicationRoleImpl(String name, Icon icon, String titleKey, String descriptionKey, List<PrivilegeGroup> privilegeGroups) {
        this.name = name;
        this.icon = icon;
        this.titleKey = titleKey;
        this.descriptionKey = descriptionKey;
        this.privilegeGroups = privilegeGroups;
    }

    @Override
    public void mergeApplicationRole(ApplicationRole role) {
        Map<String, PrivilegeGroup> groupMap = this.privilegeGroups.stream().collect(Collectors.toMap(PrivilegeGroup::getName, group -> group));
        ArrayList<PrivilegeGroup> updatedGroups = new ArrayList<PrivilegeGroup>();
        Set roleGroupSet = role.getPrivilegeGroups().stream().map(PrivilegeGroup::getName).collect(Collectors.toSet());
        this.privilegeGroups.stream().filter(g -> !roleGroupSet.contains(g.getName())).forEach(updatedGroups::add);
        for (PrivilegeGroup privilegeGroup : role.getPrivilegeGroups()) {
            PrivilegeGroup existingGroup = groupMap.get(privilegeGroup.getName());
            if (existingGroup != null) {
                PrivilegeGroup mergedGroup = PrivilegeGroup.mergeGroups(existingGroup, privilegeGroup);
                updatedGroups.add(mergedGroup);
                continue;
            }
            updatedGroups.add(privilegeGroup);
        }
        this.privilegeGroups = updatedGroups;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getTitleKey() {
        return this.titleKey;
    }

    @Override
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Override
    public List<PrivilegeGroup> getPrivilegeGroups() {
        return this.privilegeGroups;
    }
}

