/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.api.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import org.teamapps.event.Event;

public class ApplicationConfig<CONFIG> {
    private CONFIG config;
    public final Event<CONFIG> onConfigUpdate = new Event();

    public CONFIG getConfig() {
        return this.config;
    }

    public void setConfig(CONFIG config) {
        this.config = config;
    }

    public void updateConfig(CONFIG config) {
        this.config = config;
        this.onConfigUpdate.fire(config);
    }

    public void updateConfig(String xml, ClassLoader classLoader) throws Exception {
        try {
            XmlMapper xmlMapper = this.createXmlMapper(classLoader);
            Class<?> configClass = this.config.getClass();
            Object config = xmlMapper.readValue(xml, configClass);
            this.setConfig(config);
            this.onConfigUpdate.fire(config);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public String getConfigXml(ClassLoader classLoader) {
        if (this.getConfig() == null) {
            return null;
        }
        try {
            XmlMapper xmlMapper = this.createXmlMapper(classLoader);
            return xmlMapper.writeValueAsString(this.getConfig());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private XmlMapper createXmlMapper(ClassLoader classLoader) {
        XmlMapper xmlMapper = new XmlMapper();
        TypeFactory typeFactory = TypeFactory.defaultInstance().withClassLoader(classLoader);
        xmlMapper.enable(SerializationFeature.INDENT_OUTPUT);
        xmlMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        xmlMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        xmlMapper.disable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES);
        xmlMapper.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        xmlMapper.setTypeFactory(typeFactory);
        return xmlMapper;
    }
}

