/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.localize.translation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teamapps.localize.translation.DeepLTranslation;
import org.teamapps.localize.translation.GoogleTranslation;
import org.teamapps.localize.translation.TranslationService;

public class MachineTranslation
implements TranslationService {
    private DeepLTranslation deepLTranslation;
    private GoogleTranslation googleTranslation;
    private List<TranslationService> services = new ArrayList<TranslationService>();
    private Set<String> supportedLanguages = new HashSet<String>();

    public void setGoogleTranslationKey(String googleKey) {
        if (googleKey != null && this.googleTranslation == null) {
            try {
                this.googleTranslation = new GoogleTranslation(googleKey);
                this.services.add(this.googleTranslation);
                this.supportedLanguages.addAll(this.googleTranslation.getSupportedLanguages());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setDeepLKey(String deepLKey) {
        if (deepLKey != null && this.deepLTranslation == null) {
            this.deepLTranslation = new DeepLTranslation(deepLKey);
            this.services.add(this.deepLTranslation);
            this.supportedLanguages.addAll(this.deepLTranslation.getSupportedLanguages());
        }
    }

    public boolean translationServiceAvailable() {
        return !this.services.isEmpty();
    }

    @Override
    public Set<String> getSupportedLanguages() {
        HashSet<String> supportedLanguages = new HashSet<String>();
        this.services.forEach(service -> supportedLanguages.addAll(service.getSupportedLanguages()));
        return supportedLanguages;
    }

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) {
        for (TranslationService service : this.services) {
            if (!service.canTranslate(sourceLanguage, targetLanguage)) continue;
            String result = service.translate(MachineTranslation.transformParameters(text), sourceLanguage, targetLanguage);
            return MachineTranslation.restoreParameters(result);
        }
        return null;
    }

    private static String transformParameters(String s) {
        if (s == null) {
            return s;
        }
        for (int i = 0; i < 10; ++i) {
            s = s.replace("{" + i + "}", "<attr-" + i + "/>");
        }
        return s;
    }

    private static String restoreParameters(String s) {
        if (s == null) {
            return s;
        }
        for (int i = 0; i < 10; ++i) {
            s = s.replace("<attr-" + i + "/>", "{" + i + "}");
        }
        return s;
    }

    @Override
    public long getTranslatedCharacters() {
        return this.services.stream().mapToLong(service -> service.getTranslatedCharacters()).sum();
    }

    @Override
    public boolean canTranslate(String sourceLanguage, String targetLanguage) {
        return this.supportedLanguages.contains(sourceLanguage) && this.supportedLanguages.contains(targetLanguage);
    }
}

