/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.app.multi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.teamapps.app.ComponentBuilder;
import org.teamapps.app.ComponentUpdateHandler;
import org.teamapps.app.multi.ApplicationGroup;
import org.teamapps.app.multi.ApplicationHandlerCaptions;
import org.teamapps.app.multi.ApplicationLaunchInfo;
import org.teamapps.app.multi.ApplicationLaunchInfoProvider;
import org.teamapps.app.multi.ApplicationLauncherComponentProvider;
import org.teamapps.app.multi.LogoutHandler;
import org.teamapps.app.multi.MultiApplicationHandler;
import org.teamapps.auth.AuthenticationProvider;
import org.teamapps.auth.LoginHandler;
import org.teamapps.auth.SessionAuthenticatedUserResolver;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.config.ClientConfigProvider;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.Icon;
import org.teamapps.theme.Theme;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.itemview.ItemGroup;
import org.teamapps.ux.component.itemview.SimpleItem;
import org.teamapps.ux.component.itemview.SimpleItemGroup;
import org.teamapps.ux.component.itemview.SimpleItemView;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.component.tabpanel.Tab;
import org.teamapps.ux.component.tabpanel.TabPanel;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class StandardMultiApplicationHandler<USER>
implements MultiApplicationHandler<USER> {
    private final SessionAuthenticatedUserResolver<USER> sessionAuthenticatedUserResolver;
    private final ApplicationLaunchInfoProvider<USER> applicationLaunchInfoProvider;
    private final List<ComponentBuilder> componentBuilders;
    private final List<LogoutHandler<USER>> logoutHandlers;
    private ComponentBuilder loggedOutComponentBuilder;
    private Function<USER, ApplicationHandlerCaptions> userApplicationCaptionsFunction = user -> new ApplicationHandlerCaptions();
    private ClientConfigProvider<USER> clientConfigProvider;
    private Icon applicationLauncherIcon = MaterialIcon.APPS;
    private Icon logoutIcon = MaterialIcon.DELETE;

    public StandardMultiApplicationHandler(AuthenticationProvider<USER> authenticationProvider, ApplicationLaunchInfoProvider<USER> applicationLaunchInfoProvider, ClientConfigProvider<USER> clientConfigProvider) {
        this(authenticationProvider.getSessionAuthenticatedUserResolver(), applicationLaunchInfoProvider, clientConfigProvider, null);
    }

    public StandardMultiApplicationHandler(LoginHandler<USER> loginHandler, ApplicationLaunchInfoProvider<USER> applicationLaunchInfoProvider) {
        this(loginHandler.getAuthenticationProvider().getSessionAuthenticatedUserResolver(), applicationLaunchInfoProvider, loginHandler.getClientConfigProvider(), loginHandler);
    }

    public StandardMultiApplicationHandler(SessionAuthenticatedUserResolver<USER> sessionAuthenticatedUserResolver, ApplicationLaunchInfoProvider<USER> applicationLaunchInfoProvider) {
        this(sessionAuthenticatedUserResolver, applicationLaunchInfoProvider, null, null);
    }

    public StandardMultiApplicationHandler(SessionAuthenticatedUserResolver<USER> sessionAuthenticatedUserResolver, ApplicationLaunchInfoProvider<USER> applicationLaunchInfoProvider, ClientConfigProvider<USER> clientConfigProvider, ComponentBuilder loggedOutComponentBuilder) {
        this.sessionAuthenticatedUserResolver = sessionAuthenticatedUserResolver;
        this.applicationLaunchInfoProvider = applicationLaunchInfoProvider;
        this.logoutHandlers = new ArrayList<LogoutHandler<USER>>();
        this.componentBuilders = new ArrayList<ComponentBuilder>();
        this.loggedOutComponentBuilder = loggedOutComponentBuilder != null ? loggedOutComponentBuilder : updateHandler -> new Panel((Icon)MaterialIcon.ERROR, "No logged out component builder registered");
        this.clientConfigProvider = clientConfigProvider != null ? clientConfigProvider : ClientConfigProvider.create();
    }

    public void setLoggedOutComponentBuilder(ComponentBuilder loggedOutComponentBuilder) {
        this.loggedOutComponentBuilder = loggedOutComponentBuilder;
    }

    public void setClientConfigProvider(ClientConfigProvider<USER> clientConfigProvider) {
        this.clientConfigProvider = clientConfigProvider;
    }

    @Override
    public void addApplication(ComponentBuilder componentBuilder) {
        this.componentBuilders.add(componentBuilder);
    }

    @Override
    public void addLogoutHandler(LogoutHandler<USER> logoutHandler) {
        this.logoutHandlers.add(logoutHandler);
    }

    @Override
    public ApplicationLauncherComponentProvider getApplicationLauncherComponentProvider(ComponentUpdateHandler updateHandler) {
        return () -> this.createApplication(updateHandler, null, true);
    }

    @Override
    public Component buildComponent(ComponentUpdateHandler updateHandler) {
        USER user = this.sessionAuthenticatedUserResolver.getUser();
        List<Map.Entry<ApplicationGroup, List<ApplicationInfo>>> sortedApplicationGroups = this.getSortedUserApplicationGroups(user);
        SessionContext context = CurrentSessionContext.get();
        boolean isMobile = context.getClientInfo().isMobileDevice();
        if (isMobile) {
            return this.createApplication(updateHandler, null, false);
        }
        TabPanel tabPanel = new TabPanel();
        this.createApplication(updateHandler, tabPanel, false);
        return tabPanel;
    }

    private Component createApplication(ComponentUpdateHandler updateHandler, TabPanel tabPanel, boolean launcherPanelOnly) {
        USER user = this.sessionAuthenticatedUserResolver.getUser();
        ApplicationHandlerCaptions captions = this.userApplicationCaptionsFunction.apply(user);
        List<Map.Entry<ApplicationGroup, List<ApplicationInfo>>> sortedApplicationGroups = this.getSortedUserApplicationGroups(user);
        SessionContext context = CurrentSessionContext.get();
        HashMap tabByComponentBuilder = new HashMap();
        HashMap applicationInfoByTab = new HashMap();
        SimpleItemView applicationLauncher = new SimpleItemView();
        if (!launcherPanelOnly && tabPanel == null) {
            for (Map.Entry<ApplicationGroup, List<ApplicationInfo>> entry2 : sortedApplicationGroups) {
                for (ApplicationInfo info : entry2.getValue()) {
                    if (!info.getLaunchInfo().isPreload() || !info.getLaunchInfo().isDisplay()) continue;
                    return info.getComponentBuilder().buildComponent(updateHandler);
                }
            }
        }
        Tab homeTab = null;
        Panel panel = new Panel(this.applicationLauncherIcon, captions.getApplications());
        TextField applicationsSearchField = new TextField();
        applicationsSearchField.setShowClearButton(true);
        applicationsSearchField.setEmptyText(captions.getSearch() + "...");
        applicationsSearchField.onTextInput().addListener(arg_0 -> ((SimpleItemView)applicationLauncher).setFilter(arg_0));
        panel.setRightHeaderField((AbstractField)applicationsSearchField);
        panel.setContent((Component)applicationLauncher);
        if (tabPanel != null) {
            Panel framePanel = new Panel();
            framePanel.setHideTitleBar(true);
            framePanel.setPadding(5);
            framePanel.setContent((Component)panel);
            framePanel.setBodyBackgroundColor((Color)RgbaColor.WHITE.withAlpha(0.001f));
            panel.setBodyBackgroundColor((Color)RgbaColor.WHITE.withAlpha(0.7f));
            homeTab = new Tab(this.applicationLauncherIcon, captions.getHome(), (Component)framePanel);
            tabPanel.addTab(homeTab, true);
        }
        sortedApplicationGroups.forEach(entry -> {
            ApplicationGroup applicationGroup = (ApplicationGroup)entry.getKey();
            List applicationInfos = (List)entry.getValue();
            SimpleItemGroup itemGroup = new SimpleItemGroup(applicationGroup.getIcon(), applicationGroup.getTitle());
            itemGroup.setButtonWidth(tabPanel != null ? 300.0f : 0.97f);
            applicationInfos.forEach(info -> {
                ComponentBuilder componentBuilder = info.getComponentBuilder();
                ApplicationLaunchInfo launchInfo = info.getLaunchInfo();
                SimpleItem item = itemGroup.addItem(launchInfo.getIcon(), launchInfo.getTitle(), launchInfo.getDescription());
                itemGroup.setItemTemplate((Template)BaseTemplate.LIST_ITEM_EXTRA_VERY_LARGE_ICON_TWO_LINES);
                item.setPayload(info);
                if (!launcherPanelOnly && tabPanel != null && launchInfo.isPreload()) {
                    Tab tab = new Tab(launchInfo.getIcon(), launchInfo.getTitle(), componentBuilder.buildComponent(updateHandler));
                    tab.setCloseable(launchInfo.isClosable());
                    tabByComponentBuilder.put(componentBuilder, tab);
                    applicationInfoByTab.put(tab, info);
                    tabPanel.addTab(tab, launchInfo.isDisplay());
                }
                item.onClick.addListener(aVoid -> {
                    if (tabPanel != null) {
                        Tab tab = (Tab)tabByComponentBuilder.get(componentBuilder);
                        if (tab != null) {
                            tab.select();
                        } else {
                            tab = new Tab(launchInfo.getIcon(), launchInfo.getTitle(), componentBuilder.buildComponent(updateHandler));
                            tab.setCloseable(launchInfo.isClosable());
                            tabByComponentBuilder.put(componentBuilder, tab);
                            applicationInfoByTab.put(tab, info);
                            tabPanel.addTab(tab, true);
                        }
                    } else {
                        updateHandler.updateComponent(componentBuilder.buildComponent(updateHandler));
                    }
                    if (launchInfo.getTheme() != null) {
                        Theme theme = launchInfo.getTheme();
                        theme.getBackground().registerAndApply(context);
                        this.clientConfigProvider.setUserTheme(user, theme);
                    } else {
                        this.clientConfigProvider.setUserTheme(user, this.clientConfigProvider.getUserTheme(user));
                    }
                });
            });
            applicationLauncher.addGroup((ItemGroup)itemGroup);
        });
        if (tabPanel == null) {
            SimpleItemGroup itemGroup = new SimpleItemGroup(this.logoutIcon, captions.getLogout());
            itemGroup.setButtonWidth(0.97f);
            itemGroup.setItemTemplate((Template)BaseTemplate.LIST_ITEM_EXTRA_VERY_LARGE_ICON_TWO_LINES);
            SimpleItem item = itemGroup.addItem(this.logoutIcon, captions.getLogout(), "");
            item.onClick.addListener(aVoid -> this.handleLogout(user, updateHandler));
            return panel;
        }
        Tab finalHomeTab = homeTab;
        tabPanel.onTabSelected.addListener(tab -> {
            ApplicationInfo applicationInfo = (ApplicationInfo)applicationInfoByTab.get(tab);
            if (tab.equals(finalHomeTab)) {
                this.clientConfigProvider.setUserTheme(user, this.clientConfigProvider.getUserTheme(user));
            } else if (applicationInfo == null) {
                this.handleLogout(user, updateHandler);
            } else if (applicationInfo.getLaunchInfo().getTheme() != null) {
                Theme theme = applicationInfo.getLaunchInfo().getTheme();
                theme.getBackground().registerAndApply(context);
                this.clientConfigProvider.setUserTheme(user, theme);
            } else {
                this.clientConfigProvider.setUserTheme(user, this.clientConfigProvider.getUserTheme(user));
            }
        });
        tabPanel.onTabClosed.addListener(tab -> {
            ApplicationInfo applicationInfo = (ApplicationInfo)applicationInfoByTab.get(tab);
            tabByComponentBuilder.remove(applicationInfo.getComponentBuilder());
        });
        Tab tab2 = new Tab(this.logoutIcon, captions.getLogout(), null).setRightSide(true).setLazyLoading(true);
        tabPanel.addTab(tab2);
        return null;
    }

    private List<Map.Entry<ApplicationGroup, List<ApplicationInfo>>> getSortedUserApplicationGroups(USER user) {
        HashMap appInfosByGroup = new HashMap();
        this.componentBuilders.forEach(componentBuilder -> {
            ApplicationLaunchInfo launchInfo = this.applicationLaunchInfoProvider.getApplicationLaunchInfo(user, (ComponentBuilder)componentBuilder);
            if (launchInfo.isAccessible()) {
                appInfosByGroup.computeIfAbsent(launchInfo.getApplicationGroup(), applicationGroup -> new ArrayList()).add(new ApplicationInfo((ComponentBuilder)componentBuilder, launchInfo));
            }
        });
        return appInfosByGroup.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
    }

    private void handleLogout(USER user, ComponentUpdateHandler updateHandler) {
        updateHandler.updateComponent(this.loggedOutComponentBuilder.buildComponent(updateHandler));
        this.logoutHandlers.forEach(handler -> handler.handleUserLogout(user));
    }

    public void setApplicationLauncherIcon(Icon applicationLauncherIcon) {
        this.applicationLauncherIcon = applicationLauncherIcon;
    }

    public void setLogoutIcon(Icon logoutIcon) {
        this.logoutIcon = logoutIcon;
    }

    public void setUserApplicationCaptionsFunction(Function<USER, ApplicationHandlerCaptions> userApplicationCaptionsFunction) {
        this.userApplicationCaptionsFunction = userApplicationCaptionsFunction;
    }

    static class ApplicationInfo {
        private final ComponentBuilder componentBuilder;
        private final ApplicationLaunchInfo launchInfo;

        ApplicationInfo(ComponentBuilder componentBuilder, ApplicationLaunchInfo launchInfo) {
            this.componentBuilder = componentBuilder;
            this.launchInfo = launchInfo;
        }

        public ComponentBuilder getComponentBuilder() {
            return this.componentBuilder;
        }

        public ApplicationLaunchInfo getLaunchInfo() {
            return this.launchInfo;
        }
    }
}

