/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.localize;

import java.util.Locale;
import java.util.ResourceBundle;
import org.teamapps.localize.AbstractLocalizationProviderFactory;
import org.teamapps.localize.LocalizationProvider;
import org.teamapps.localize.StandardResourceBundle;
import org.teamapps.localize.store.LocalizationStore;

public class StandardLocalizationProvider
implements LocalizationProvider {
    private final String prefix;
    private final LocalizationStore localizationStore;

    public StandardLocalizationProvider(String prefix, LocalizationStore localizationStore) {
        this.prefix = prefix;
        this.localizationStore = localizationStore;
    }

    @Override
    public String getLocalized(Locale locale, String key) {
        return this.localizationStore.getLocalization(locale.getLanguage(), AbstractLocalizationProviderFactory.createLookupKey(this.prefix, key));
    }

    @Override
    public String getLocalized(Locale locale, String key, Object ... parameters) {
        return this.localizationStore.getLocalization(locale.getLanguage(), AbstractLocalizationProviderFactory.createLookupKey(this.prefix, key), parameters);
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        return new StandardResourceBundle(locale.getLanguage(), this.prefix, this.localizationStore);
    }
}

