/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.config;

import com.ibm.icu.util.ULocale;
import java.time.ZoneId;
import java.util.Locale;
import org.teamapps.config.LocaleProvider;
import org.teamapps.config.StandardClientConfigProvider;
import org.teamapps.config.ThemeProvider;
import org.teamapps.config.TimeZoneProvider;
import org.teamapps.theme.Theme;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.ux.session.StylingTheme;

public interface ClientConfigProvider<USER>
extends LocaleProvider<USER>,
TimeZoneProvider<USER>,
ThemeProvider<USER> {
    public static <USER> ClientConfigProvider create(LocaleProvider<USER> localeProvider, TimeZoneProvider<USER> timeZoneProvider, ThemeProvider<USER> themeProvider) {
        return new StandardClientConfigProvider<USER>(localeProvider, timeZoneProvider, themeProvider);
    }

    public static <USER> ClientConfigProvider create(LocaleProvider<USER> localeProvider) {
        return new StandardClientConfigProvider<USER>(localeProvider, null, null);
    }

    public static <USER> ClientConfigProvider create(TimeZoneProvider<USER> timeZoneProvider) {
        return new StandardClientConfigProvider<USER>(null, timeZoneProvider, null);
    }

    public static <USER> ClientConfigProvider create(ThemeProvider<USER> themeProvider) {
        return new StandardClientConfigProvider<USER>(null, null, themeProvider);
    }

    public static <USER> ClientConfigProvider create() {
        return new StandardClientConfigProvider();
    }

    public void setUserTheme(USER var1, Theme var2);

    public void updateClientConfiguration(USER var1);

    public void setClientSessionConfiguration(Locale var1, ZoneId var2, Theme var3);

    public void setLocaleProvider(LocaleProvider<USER> var1);

    public void setTimeZoneProvider(TimeZoneProvider<USER> var1);

    public void setThemeProvider(ThemeProvider<USER> var1);

    public static SessionConfiguration createUserAgentSessionConfiguration(boolean darkTheme, SessionContext context) {
        boolean optimizedForTouch = false;
        StylingTheme theme = StylingTheme.DEFAULT;
        if (context.getClientInfo().isMobileDevice()) {
            optimizedForTouch = true;
            theme = StylingTheme.MODERN;
        }
        if (darkTheme) {
            theme = StylingTheme.DARK;
        }
        ULocale locale = ULocale.forLanguageTag((String)context.getClientInfo().getPreferredLanguageIso());
        return SessionConfiguration.create((ULocale)locale, (ZoneId)ZoneId.of(context.getClientInfo().getTimeZone()), (StylingTheme)theme, (boolean)optimizedForTouch);
    }
}

