/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.privilege;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teamapps.privilege.PrivilegeGroup;
import org.teamapps.privilege.preset.ApplicationRolePreset;

public class ApplicationPrivilegesInfo {
    private final String applicationNamespace;
    private final List<PrivilegeGroup> privilegeGroups;
    private final List<ApplicationRolePreset> applicationRolePresets;

    public ApplicationPrivilegesInfo(String applicationNamespace) {
        this.applicationNamespace = applicationNamespace;
        this.privilegeGroups = new ArrayList<PrivilegeGroup>();
        this.applicationRolePresets = new ArrayList<ApplicationRolePreset>();
    }

    public ApplicationPrivilegesInfo(String applicationNamespace, PrivilegeGroup ... privilegeGroups) {
        this(applicationNamespace, Arrays.asList(privilegeGroups), new ArrayList<ApplicationRolePreset>());
    }

    public ApplicationPrivilegesInfo(String applicationNamespace, List<PrivilegeGroup> privilegeGroups, List<ApplicationRolePreset> applicationRolePresets) {
        this.applicationNamespace = applicationNamespace;
        this.privilegeGroups = privilegeGroups;
        this.applicationRolePresets = applicationRolePresets;
    }

    public void addPrivilegeGroup(PrivilegeGroup privilegeGroup) {
        this.privilegeGroups.add(privilegeGroup);
    }

    public void addApplicationRolePreset(ApplicationRolePreset applicationRolePreset) {
        this.applicationRolePresets.add(applicationRolePreset);
    }

    public String getApplicationNamespace() {
        return this.applicationNamespace;
    }

    public List<PrivilegeGroup> getPrivilegeGroups() {
        return this.privilegeGroups;
    }

    public List<ApplicationRolePreset> getApplicationRolePresets() {
        return this.applicationRolePresets;
    }
}

