/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.auth;

import org.teamapps.app.ComponentBuilder;
import org.teamapps.app.ComponentUpdateHandler;
import org.teamapps.auth.AuthenticationProvider;
import org.teamapps.auth.AuthenticationResult;
import org.teamapps.config.ClientConfigProvider;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.Icon;
import org.teamapps.theme.Theme;
import org.teamapps.theme.background.Background;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.login.LoginWindow;
import org.teamapps.ux.component.panel.Panel;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class LoginHandler<USER>
implements ComponentBuilder {
    private final AuthenticationProvider<USER> authenticationProvider;
    private ComponentBuilder componentBuilder;
    private ClientConfigProvider<USER> clientConfigProvider;
    private Theme loginTheme;

    public LoginHandler(AuthenticationProvider<USER> authenticationProvider) {
        this(authenticationProvider, null, null, null);
    }

    public LoginHandler(AuthenticationProvider<USER> authenticationProvider, ComponentBuilder componentBuilder) {
        this(authenticationProvider, componentBuilder, null, null);
    }

    public LoginHandler(AuthenticationProvider<USER> authenticationProvider, ComponentBuilder componentBuilder, Theme loginTheme) {
        this(authenticationProvider, componentBuilder, loginTheme, null);
    }

    public LoginHandler(AuthenticationProvider<USER> authenticationProvider, ComponentBuilder componentBuilder, Theme loginTheme, ClientConfigProvider<USER> clientConfigProvider) {
        this.authenticationProvider = authenticationProvider;
        this.componentBuilder = componentBuilder != null ? componentBuilder : updateHandler -> new Panel((Icon)MaterialIcon.ERROR, "No result component builder registered");
        this.loginTheme = loginTheme != null ? loginTheme : Theme.create(Background.createDefaultLoginBackground(), false);
        this.clientConfigProvider = clientConfigProvider != null ? clientConfigProvider : ClientConfigProvider.create();
    }

    @Override
    public Component buildComponent(ComponentUpdateHandler updateHandler) {
        SessionContext context = CurrentSessionContext.get();
        this.loginTheme.getBackground().registerAndApply(context);
        LoginWindow loginWindow = new LoginWindow();
        loginWindow.onLogin.addListener(loginData -> {
            AuthenticationResult<USER> authenticationResult = this.authenticationProvider.authenticate(loginData.login, loginData.password);
            if (authenticationResult.isSuccess()) {
                USER authenticatedUser = authenticationResult.getAuthenticatedUser();
                this.clientConfigProvider.updateClientConfiguration(authenticatedUser);
                Theme theme = this.clientConfigProvider.getUserTheme(authenticatedUser);
                this.clientConfigProvider.setUserTheme(authenticatedUser, theme);
                theme.getBackground().registerAndApply(context);
                updateHandler.updateComponent(this.componentBuilder.buildComponent(updateHandler));
            } else {
                loginWindow.setError();
            }
        });
        return loginWindow.getElegantPanel();
    }

    public USER getAuthenticatedUser(SessionContext context) {
        return this.authenticationProvider.getSessionAuthenticatedUserResolver().getUser(context);
    }

    public void setComponentBuilder(ComponentBuilder componentBuilder) {
        this.componentBuilder = componentBuilder;
    }

    public void setLoginTheme(Theme loginTheme) {
        this.loginTheme = loginTheme;
    }

    public void setClientConfigProvider(ClientConfigProvider<USER> clientConfigProvider) {
        this.clientConfigProvider = clientConfigProvider;
    }

    public AuthenticationProvider<USER> getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public ClientConfigProvider<USER> getClientConfigProvider() {
        return this.clientConfigProvider;
    }
}

