/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.localize;

import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.teamapps.localize.ExistingLocalizationsInfo;
import org.teamapps.localize.LocalizationProvider;
import org.teamapps.localize.LocalizationProviderFactory;
import org.teamapps.localize.StandardLocalizationProvider;
import org.teamapps.localize.store.LocalizationStore;

public abstract class AbstractLocalizationProviderFactory
implements LocalizationProviderFactory {
    public abstract LocalizationStore getLocalizationStore();

    @Override
    public synchronized LocalizationProvider createLocalizationProvider(ExistingLocalizationsInfo existingLocalizationsInfo) {
        String applicationNamespace = existingLocalizationsInfo.getApplicationNamespace();
        LocalizationStore handler = this.getLocalizationStore();
        handler.startImportingApplicationNamespace(applicationNamespace);
        existingLocalizationsInfo.getResourceBundleInfos().forEach(resourceBundleInfo -> {
            for (Locale translation : resourceBundleInfo.getTranslations()) {
                ResourceBundle bundle = resourceBundleInfo.getResourceBundleByLocaleFunction().apply(translation);
                if (bundle instanceof PropertyResourceBundle) {
                    PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)bundle;
                    for (String key : bundle.keySet()) {
                        Object result = propertyResourceBundle.handleGetObject(key);
                        if (result == null) continue;
                        String value = bundle.getString(key);
                        if (!this.checkNotEmpty(applicationNamespace, translation.getLanguage(), key, value)) continue;
                        handler.addExistingLocalizationEntry(applicationNamespace, translation.getLanguage(), AbstractLocalizationProviderFactory.createLookupKey(applicationNamespace, key), value);
                    }
                    continue;
                }
                for (String key : bundle.keySet()) {
                    String value = bundle.getString(key);
                    if (!this.checkNotEmpty(applicationNamespace, translation.getLanguage(), key, value)) continue;
                    handler.addExistingLocalizationEntry(applicationNamespace, translation.getLanguage(), AbstractLocalizationProviderFactory.createLookupKey(applicationNamespace, key), value);
                }
            }
        });
        existingLocalizationsInfo.getDictionaries().forEach(dictionary -> {
            handler.addDictionary(applicationNamespace, dictionary.getId());
            String prefix = applicationNamespace + "." + dictionary.getId();
            dictionary.getEntries().forEach(entry -> {
                if (this.checkNotEmpty(applicationNamespace, dictionary.getId(), dictionary.getLanguage(), entry.getKey(), entry.getValue())) {
                    handler.addDictionaryEntry(applicationNamespace, dictionary.getId(), dictionary.getLanguage(), AbstractLocalizationProviderFactory.createLookupKey(prefix, entry.getKey()), entry.getValue());
                }
            });
            dictionary.setLocalizationProvider(new StandardLocalizationProvider(prefix, handler));
        });
        handler.finishImportingApplicationNamespace(applicationNamespace);
        return new StandardLocalizationProvider(applicationNamespace, handler);
    }

    public static String createLookupKey(String prefix, String key) {
        return prefix + "." + key;
    }

    private boolean checkNotEmpty(String ... values) {
        for (String value : values) {
            boolean result = this.checkNotEmpty(value);
            if (result) continue;
            return false;
        }
        return true;
    }

    private boolean checkNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }
}

