/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.teamapps.auth.AuthenticationHandler;
import org.teamapps.auth.AuthenticationProvider;
import org.teamapps.auth.AuthenticationResult;
import org.teamapps.auth.LoginResolver;
import org.teamapps.auth.SessionAuthenticatedUserResolver;
import org.teamapps.auth.hash.SecurePasswordHash;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class StandardAuthenticationProvider<USER>
implements AuthenticationProvider<USER> {
    private final LoginResolver<USER> loginResolver;
    private final SecurePasswordHash securePasswordHash;
    private final Map<SessionContext, USER> userBySessionMap;
    private final List<AuthenticationHandler<USER>> authenticationHandlers;

    public StandardAuthenticationProvider(LoginResolver<USER> loginResolver, SecurePasswordHash securePasswordHash) {
        this.loginResolver = loginResolver;
        this.securePasswordHash = securePasswordHash;
        this.userBySessionMap = Collections.synchronizedMap(new WeakHashMap());
        this.authenticationHandlers = new ArrayList<AuthenticationHandler<USER>>();
    }

    @Override
    public AuthenticationResult<USER> authenticate(String login, String password) {
        String passwordHash = this.loginResolver.resolvePasswordHash(login);
        if (passwordHash != null && this.securePasswordHash.verifyPassword(password, passwordHash)) {
            SessionContext context = CurrentSessionContext.get();
            Object user = this.loginResolver.resolveLogin(login);
            this.userBySessionMap.put(context, user);
            this.authenticationHandlers.forEach(handler -> handler.handleAuthenticatedUser(user, context));
            return AuthenticationResult.createSuccessResult(user);
        }
        return AuthenticationResult.createError();
    }

    @Override
    public void addAuthenticationHandler(AuthenticationHandler<USER> authenticationHandler) {
        this.authenticationHandlers.add(authenticationHandler);
    }

    @Override
    public SessionAuthenticatedUserResolver<USER> getSessionAuthenticatedUserResolver() {
        return context -> this.userBySessionMap.get(context);
    }
}

