/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.localize;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.teamapps.localize.AbstractLocalizationProviderFactory;
import org.teamapps.localize.store.FileLocalizationStore;
import org.teamapps.localize.store.LocalizationStore;
import org.teamapps.localize.translation.MachineTranslation;

public class MachineTranslationLocalizationProviderFactory
extends AbstractLocalizationProviderFactory {
    private static final List<String> preferredTranslationLanguages = Arrays.asList("en", "de", "fr", "es", "pt", "nl", "it", "pl", "ru");
    private final LocalizationStore localizationStore;
    private final MachineTranslation machineTranslationService;
    private final List<String> requiredLanguages;

    public static MachineTranslationLocalizationProviderFactory create(LocalizationStore localizationStore, String deepLKey, String googleKey, String ... requiredLanguages) {
        return new MachineTranslationLocalizationProviderFactory(localizationStore, deepLKey, googleKey, Arrays.asList(requiredLanguages));
    }

    public static MachineTranslationLocalizationProviderFactory createWithFileStore(File directory, String deepLKey, String googleKey, String ... requiredLanguages) throws IOException {
        FileLocalizationStore fileLocalizationStore = new FileLocalizationStore(directory);
        return new MachineTranslationLocalizationProviderFactory(fileLocalizationStore, deepLKey, googleKey, Arrays.asList(requiredLanguages));
    }

    public static MachineTranslationLocalizationProviderFactory createWithFileStore(File directory, String deepLKey, String googleKey, Locale ... requiredLanguages) throws IOException {
        FileLocalizationStore fileLocalizationStore = new FileLocalizationStore(directory);
        return new MachineTranslationLocalizationProviderFactory(fileLocalizationStore, deepLKey, googleKey, MachineTranslationLocalizationProviderFactory.getLocales(requiredLanguages));
    }

    private static List<String> getLocales(Locale[] locales) {
        return Arrays.asList(locales).stream().map(locale -> locale.getLanguage()).collect(Collectors.toList());
    }

    protected MachineTranslationLocalizationProviderFactory(LocalizationStore localizationStore, String deepLKey, String googleKey, List<String> requiredLanguages) {
        this.localizationStore = localizationStore;
        this.machineTranslationService = new MachineTranslation();
        this.machineTranslationService.setDeepLKey(deepLKey);
        this.machineTranslationService.setGoogleTranslationKey(googleKey);
        this.requiredLanguages = requiredLanguages;
    }

    public void machineTranslateAllMissingEntries() {
        List<String> usedLanguages = this.localizationStore.getAllUsedLanguages();
        List<String> keys = this.localizationStore.getAllUsedStoreKeys();
        for (String requiredLanguage : this.requiredLanguages) {
            if (!this.machineTranslationService.canTranslate(requiredLanguage, requiredLanguage)) continue;
            for (String key : keys) {
                String text;
                if (this.localizationStore.getLocalization(requiredLanguage, key) != null) continue;
                String sourceText = null;
                String sourceLanguage = null;
                for (String preferredSourceLanguage : preferredTranslationLanguages) {
                    text = this.localizationStore.getLocalization(preferredSourceLanguage, key);
                    if (text == null) continue;
                    sourceText = text;
                    sourceLanguage = preferredSourceLanguage;
                    break;
                }
                if (sourceText == null) {
                    for (String usedLanguage : usedLanguages) {
                        text = this.localizationStore.getLocalization(usedLanguage, key);
                        if (text == null || !this.machineTranslationService.canTranslate(usedLanguage, requiredLanguage)) continue;
                        sourceText = text;
                        sourceLanguage = usedLanguage;
                        break;
                    }
                }
                if (sourceText == null || sourceLanguage == null) continue;
                String translation = this.machineTranslationService.translate(sourceText, sourceLanguage, requiredLanguage);
                translation = this.firstUpperIfSourceUpper(sourceText, translation);
                this.localizationStore.addTranslationResult(requiredLanguage, key, translation);
            }
        }
        this.localizationStore.finishStoreUpdates();
    }

    private String firstUpperIfSourceUpper(String source, String text) {
        if (source == null || text == null || source.isEmpty() || text.isEmpty()) {
            return text;
        }
        char c = source.substring(0, 1).charAt(0);
        if (Character.isUpperCase(c)) {
            return text.substring(0, 1).toUpperCase() + text.substring(1);
        }
        return text;
    }

    @Override
    public LocalizationStore getLocalizationStore() {
        return this.localizationStore;
    }
}

