/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.app;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.teamapps.agent.UserAgentParser;
import org.teamapps.app.ComponentBuilder;
import org.teamapps.config.ClientConfigProvider;
import org.teamapps.geoip.GeoIpLookupService;
import org.teamapps.icons.api.IconTheme;
import org.teamapps.icons.provider.IconProvider;
import org.teamapps.server.ServletRegistration;
import org.teamapps.server.UxServerContext;
import org.teamapps.ux.component.rootpanel.RootPanel;
import org.teamapps.ux.resource.ClassPathResourceProvider;
import org.teamapps.ux.resource.ResourceProvider;
import org.teamapps.ux.resource.ResourceProviderServlet;
import org.teamapps.ux.session.ClientGeoIpInfo;
import org.teamapps.ux.session.ClientUserAgent;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class ApplicationWebController
implements WebController {
    private final ComponentBuilder componentBuilder;
    private final boolean darkTheme;
    private GeoIpLookupService geoIpLookupService;
    private UserAgentParser userAgentParser = new UserAgentParser();
    private List<ServletRegistration> servletRegistrations = new ArrayList<ServletRegistration>();
    private List<Function<UxServerContext, ServletRegistration>> servletRegistrationFactories = new ArrayList<Function<UxServerContext, ServletRegistration>>();
    private IconProvider defaultIconProvider;
    private List<IconProvider> iconProviders = new ArrayList<IconProvider>();

    public ApplicationWebController(ComponentBuilder componentBuilder) {
        this(componentBuilder, false, null);
    }

    public ApplicationWebController(ComponentBuilder componentBuilder, boolean darkTheme) {
        this(componentBuilder, darkTheme, null);
    }

    public ApplicationWebController(ComponentBuilder componentBuilder, boolean darkTheme, String geoIpDatabasePath) {
        this.componentBuilder = componentBuilder;
        this.darkTheme = darkTheme;
        this.setGeoIpLookupService(geoIpDatabasePath);
    }

    public void onSessionStart(SessionContext context) {
        if (context.getClientInfo() != null && context.getClientInfo().getUserAgent() != null) {
            ClientUserAgent clientUserAgent = this.userAgentParser.parseUserAgent(context.getClientInfo().getUserAgent());
            context.getClientInfo().setUserAgentData(clientUserAgent);
            if (this.geoIpLookupService != null) {
                ClientGeoIpInfo clientGeoIpInfo = this.geoIpLookupService.getClientGeoIpInfo(context.getClientInfo().getIp());
                context.getClientInfo().setGeoIpInfo(clientGeoIpInfo);
            }
        }
        RootPanel rootPanel = new RootPanel();
        context.addRootComponent(null, rootPanel);
        rootPanel.setContent(this.componentBuilder.buildComponent(component -> rootPanel.setContent(component)));
    }

    private void setGeoIpLookupService(String geoIpDatabasePath) {
        if (geoIpDatabasePath == null || !new File(geoIpDatabasePath).exists()) {
            return;
        }
        new Thread(() -> {
            try {
                this.geoIpLookupService = new GeoIpLookupService(geoIpDatabasePath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void setDefaultIconProvider(IconProvider defaultIconProvider) {
        this.defaultIconProvider = defaultIconProvider;
    }

    public void addIconProvider(IconProvider iconProvider) {
        this.iconProviders.add(iconProvider);
    }

    public IconTheme getDefaultIconTheme(boolean isMobile) {
        return super.getDefaultIconTheme(isMobile);
    }

    public IconProvider getIconProvider() {
        return this.defaultIconProvider != null ? this.defaultIconProvider : super.getIconProvider();
    }

    public List<IconProvider> getAdditionalIconProvider() {
        return this.iconProviders;
    }

    public SessionConfiguration createSessionConfiguration(SessionContext context) {
        return ClientConfigProvider.createUserAgentSessionConfiguration(this.darkTheme, context);
    }

    public Collection<ServletRegistration> getServletRegistrations(UxServerContext serverContext) {
        ArrayList<ServletRegistration> registrations = new ArrayList<ServletRegistration>();
        registrations.addAll(this.servletRegistrations);
        registrations.addAll(this.servletRegistrationFactories.stream().map(f -> (ServletRegistration)f.apply(serverContext)).collect(Collectors.toList()));
        return registrations;
    }

    public void addClassPathResourceProvider(String basePackage, String prefix) {
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet((ResourceProvider)new ClassPathResourceProvider(basePackage)), (String)prefix + "*"));
    }

    public void addServletRegistration(ServletRegistration servletRegistration) {
        this.servletRegistrations.add(servletRegistration);
    }

    public void addServletRegistrationFactory(Function<UxServerContext, ServletRegistration> servletRegistrationFactory) {
        this.servletRegistrationFactories.add(servletRegistrationFactory);
    }
}

