/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.auth;

import org.teamapps.auth.AuthenticationHandler;
import org.teamapps.auth.AuthenticationResult;
import org.teamapps.auth.LoginResolver;
import org.teamapps.auth.SessionAuthenticatedUserResolver;
import org.teamapps.auth.StandardAuthenticationProvider;
import org.teamapps.auth.hash.SecurePasswordHash;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public interface AuthenticationProvider<USER> {
    public static <USER> AuthenticationProvider<USER> createAuthenticationProvider(LoginResolver<USER> loginResolver, SecurePasswordHash securePasswordHash) {
        return new StandardAuthenticationProvider<USER>(loginResolver, securePasswordHash);
    }

    public static <USER> AuthenticationProvider<USER> createAuthenticationProvider(LoginResolver<USER> loginResolver) {
        return new StandardAuthenticationProvider<USER>(loginResolver, SecurePasswordHash.createDefault());
    }

    public AuthenticationResult<USER> authenticate(String var1, String var2);

    default public USER getAuthenticatedUser() {
        return this.getAuthenticatedUser(CurrentSessionContext.get());
    }

    default public USER getAuthenticatedUser(SessionContext context) {
        return this.getSessionAuthenticatedUserResolver().getUser(context);
    }

    public void addAuthenticationHandler(AuthenticationHandler<USER> var1);

    public SessionAuthenticatedUserResolver<USER> getSessionAuthenticatedUserResolver();
}

