/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.localize.store;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.teamapps.localize.store.LocalizationStore;

public class FileLocalizationStore
implements LocalizationStore {
    private static final String DELIMITER = ":\t";
    private static final String FILE_PREFIX = "localization_";
    private static final String FILE_SUFFIX = ".txt";
    private final File storeDirectory;
    private final Map<String, Map<String, String>> translationMap;

    public FileLocalizationStore(File storeDirectory) throws IOException {
        this.storeDirectory = storeDirectory;
        this.translationMap = new HashMap<String, Map<String, String>>();
        if (!storeDirectory.exists()) {
            storeDirectory.mkdir();
        }
        this.loadEntries();
    }

    private void loadEntries() throws IOException {
        for (File file : this.storeDirectory.listFiles()) {
            String name = file.getName();
            if (!name.endsWith(FILE_SUFFIX) || !name.startsWith(FILE_PREFIX)) continue;
            String language = name.substring(FILE_PREFIX.length(), name.lastIndexOf(46));
            Map languageTranslations = this.translationMap.computeIfAbsent(language, s -> new HashMap());
            List translations = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
            for (String translation : translations) {
                String[] parts;
                if (translation.startsWith("#") || translation.startsWith("//") || (parts = translation.split(DELIMITER)).length != 2) continue;
                languageTranslations.put(parts[0], parts[1]);
            }
        }
    }

    public void writeLocalizationFiles() throws IOException {
        for (Map.Entry<String, Map<String, String>> entry : this.translationMap.entrySet()) {
            String language = entry.getKey();
            Map<String, String> translations = entry.getValue();
            File file = new File(this.storeDirectory, FILE_PREFIX + language + FILE_SUFFIX);
            StringBuilder translationLines = new StringBuilder();
            translations.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(localizationEntry -> {
                String translationLine = this.createTranslationLine((String)localizationEntry.getKey(), (String)localizationEntry.getValue());
                translationLines.append(translationLine);
            });
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), StandardCharsets.UTF_8));
            writer.write(translationLines.toString());
            writer.close();
        }
    }

    private String createTranslationLine(String key, String value) {
        return key + DELIMITER + value + "\n";
    }

    @Override
    public String getLocalization(String language, String lookupKey) {
        Map<String, String> languageTranslations = this.translationMap.get(language);
        if (languageTranslations != null) {
            return languageTranslations.get(lookupKey);
        }
        return null;
    }

    @Override
    public void addTranslationResult(String language, String lookupKey, String value) {
        this.translationMap.computeIfAbsent(language, s -> new HashMap()).put(lookupKey, value);
    }

    @Override
    public void startImportingApplicationNamespace(String applicationNamespace) {
    }

    @Override
    public void addExistingLocalizationEntry(String applicationNamespace, String language, String lookupKey, String value) {
        this.translationMap.computeIfAbsent(language, s -> new HashMap()).put(lookupKey, value);
    }

    @Override
    public void addDictionary(String applicationNamespace, String dictionaryId) {
    }

    @Override
    public void addDictionaryEntry(String applicationNamespace, String dictionaryId, String language, String lookupKey, String value) {
        this.translationMap.computeIfAbsent(language, s -> new HashMap()).put(lookupKey, value);
    }

    @Override
    public void finishImportingApplicationNamespace(String applicationNamespace) {
    }

    @Override
    public void finishStoreUpdates() {
        try {
            this.writeLocalizationFiles();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getAllUsedStoreKeys() {
        return this.translationMap.values().stream().flatMap(map -> map.keySet().stream()).collect(Collectors.toList());
    }

    @Override
    public List<String> getAllUsedLanguages() {
        return new ArrayList<String>(this.translationMap.keySet());
    }
}

