/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.localize;

import java.util.Locale;
import java.util.ResourceBundle;
import org.teamapps.ux.session.SessionContext;

public interface LocalizationProvider {
    default public boolean matchesLocalization(String key, String query) {
        if (query == null || query.isEmpty()) {
            return true;
        }
        return this.getLocalizedOrEmptyString(key).toLowerCase().contains(query.toLowerCase());
    }

    default public String getLocalizedOrEmptyString(String key) {
        String localized = this.getLocalized(key);
        return localized != null ? localized : "";
    }

    default public String getLocalized(String key) {
        return this.getLocalized(SessionContext.current().getLocale(), key);
    }

    default public String getLocalized(String key, Object ... parameters) {
        return this.getLocalized(SessionContext.current().getLocale(), key, parameters);
    }

    public String getLocalized(Locale var1, String var2);

    public String getLocalized(Locale var1, String var2, Object ... var3);

    default public ResourceBundle getResourceBundle() {
        return this.getResourceBundle(SessionContext.current().getLocale());
    }

    public ResourceBundle getResourceBundle(Locale var1);
}

