/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.localize;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.localize.AbstractLocalizationProviderFactory;
import org.teamapps.localize.store.FileLocalizationStore;
import org.teamapps.localize.store.LocalizationStore;
import org.teamapps.localize.translation.MachineTranslation;

public class MachineTranslationLocalizationProviderFactory
extends AbstractLocalizationProviderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MachineTranslationLocalizationProviderFactory.class);
    private static List<String> preferredTranslationLanguages = Arrays.asList("en", "de", "fr", "es", "pt", "nl", "it", "pl", "ru");
    private final LocalizationStore localizationStore;
    private final String deepLKey;
    private final String googleKey;
    private MachineTranslation machineTranslationService;
    private final List<String> requiredLanguages;

    public static MachineTranslationLocalizationProviderFactory create(LocalizationStore localizationStore, String deepLKey, String googleKey, String ... requiredLanguages) {
        return new MachineTranslationLocalizationProviderFactory(localizationStore, deepLKey, googleKey, Arrays.asList(requiredLanguages));
    }

    public static MachineTranslationLocalizationProviderFactory createWithFileStore(File directory, String deepLKey, String googleKey, String ... requiredLanguages) throws IOException {
        FileLocalizationStore fileLocalizationStore = new FileLocalizationStore(directory);
        return new MachineTranslationLocalizationProviderFactory(fileLocalizationStore, deepLKey, googleKey, Arrays.asList(requiredLanguages));
    }

    public static MachineTranslationLocalizationProviderFactory createWithFileStore(File directory, String deepLKey, String googleKey, Locale ... requiredLanguages) throws IOException {
        FileLocalizationStore fileLocalizationStore = new FileLocalizationStore(directory);
        return new MachineTranslationLocalizationProviderFactory(fileLocalizationStore, deepLKey, googleKey, MachineTranslationLocalizationProviderFactory.getLocales(requiredLanguages));
    }

    private static List<String> getLocales(Locale[] locales) {
        return Arrays.asList(locales).stream().map(locale -> locale.getLanguage()).collect(Collectors.toList());
    }

    protected MachineTranslationLocalizationProviderFactory(LocalizationStore localizationStore, String deepLKey, String googleKey, List<String> requiredLanguages) {
        this.localizationStore = localizationStore;
        this.deepLKey = deepLKey;
        this.googleKey = googleKey;
        this.requiredLanguages = requiredLanguages;
    }

    public void machineTranslateAllMissingEntries() {
        if (this.machineTranslationService == null) {
            LOGGER.info("Connecting to machine translation services...");
            this.machineTranslationService = new MachineTranslation();
            this.machineTranslationService.setDeepLKey(this.deepLKey);
            this.machineTranslationService.setGoogleTranslationKey(this.googleKey);
        }
        LOGGER.info("Start translating entries");
        int countTranslations = 0;
        List<String> usedLanguages = this.localizationStore.getAllUsedLanguages();
        List<String> keys = this.localizationStore.getAllUsedStoreKeys();
        for (String requiredLanguage : this.requiredLanguages) {
            if (!this.machineTranslationService.canTranslate(requiredLanguage, requiredLanguage)) continue;
            for (String key : keys) {
                String text;
                if (this.localizationStore.getLocalization(requiredLanguage, key) != null) continue;
                String sourceText = null;
                String sourceLanguage = null;
                for (String preferredSourceLanguage : preferredTranslationLanguages) {
                    text = this.localizationStore.getLocalization(preferredSourceLanguage, key);
                    if (text == null) continue;
                    sourceText = text;
                    sourceLanguage = preferredSourceLanguage;
                    break;
                }
                if (sourceText == null) {
                    for (String usedLanguage : usedLanguages) {
                        text = this.localizationStore.getLocalization(usedLanguage, key);
                        if (text == null || !this.machineTranslationService.canTranslate(usedLanguage, requiredLanguage)) continue;
                        sourceText = text;
                        sourceLanguage = usedLanguage;
                        break;
                    }
                }
                if (sourceText == null || sourceLanguage == null) continue;
                String translation = this.machineTranslationService.translate(sourceText, sourceLanguage, requiredLanguage);
                ++countTranslations;
                translation = this.firstUpperIfSourceUpper(sourceText, translation);
                this.localizationStore.addTranslationResult(requiredLanguage, key, translation);
            }
        }
        this.localizationStore.finishStoreUpdates();
        LOGGER.info("Translated entries: " + countTranslations + ", characters:" + this.machineTranslationService.getTranslatedCharacters());
    }

    private String firstUpperIfSourceUpper(String source, String text) {
        if (source == null || text == null || source.isEmpty() || text.isEmpty()) {
            return text;
        }
        char c = source.substring(0, 1).charAt(0);
        if (Character.isUpperCase(c)) {
            return text.substring(0, 1).toUpperCase() + text.substring(1);
        }
        return text;
    }

    public static List<String> getPreferredTranslationLanguages() {
        return preferredTranslationLanguages;
    }

    public static void setPreferredTranslationLanguages(List<String> preferredTranslationLanguages) {
        MachineTranslationLocalizationProviderFactory.preferredTranslationLanguages = preferredTranslationLanguages;
    }

    @Override
    public LocalizationStore getLocalizationStore() {
        return this.localizationStore;
    }
}

