/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.privilege;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.teamapps.privilege.ApplicationPrivilegesInfo;
import org.teamapps.privilege.Privilege;
import org.teamapps.privilege.PrivilegeController;
import org.teamapps.privilege.PrivilegeGroup;
import org.teamapps.privilege.preset.PrivilegeGroupPreset;
import org.teamapps.ux.session.SessionContext;

public class SimplePrivilegeController
implements PrivilegeController {
    private final Function<SessionContext, String> applicationRoleBySessionContextFunction;
    private Map<String, Set<String>> privilegeFqnSetByApplicationRoleName;

    public SimplePrivilegeController(Function<SessionContext, String> applicationRoleBySessionContextFunction) {
        this.applicationRoleBySessionContextFunction = applicationRoleBySessionContextFunction;
        this.privilegeFqnSetByApplicationRoleName = new HashMap<String, Set<String>>();
    }

    @Override
    public void registerApplicationPrivileges(ApplicationPrivilegesInfo applicationPrivilegesInfo) {
        String applicationNamespace = applicationPrivilegesInfo.getApplicationNamespace();
        applicationPrivilegesInfo.getApplicationRolePresets().forEach(preset -> {
            String applicationRoleName = preset.getName();
            Set privilegeFqnSet = this.privilegeFqnSetByApplicationRoleName.computeIfAbsent(applicationRoleName, s -> new HashSet());
            for (PrivilegeGroupPreset privilegeGroupPreset : preset.getPrivilegeGroupPresets()) {
                PrivilegeGroup privilegeGroup = privilegeGroupPreset.getPrivilegeGroup();
                for (Privilege activePrivilege : privilegeGroupPreset.getActivePrivileges()) {
                    privilegeFqnSet.add(this.createPrivilegeFqn(applicationNamespace, privilegeGroup, activePrivilege));
                }
            }
        });
    }

    @Override
    public boolean isAllowed(SessionContext context, String applicationNamespace, PrivilegeGroup privilegeGroup, Privilege privilege) {
        String applicationRoleName = this.applicationRoleBySessionContextFunction.apply(context);
        if (applicationRoleName == null) {
            return false;
        }
        Set<String> privilegeFqnSet = this.privilegeFqnSetByApplicationRoleName.get(applicationRoleName);
        return privilegeFqnSet.contains(this.createPrivilegeFqn(applicationNamespace, privilegeGroup, privilege));
    }

    private String createPrivilegeFqn(String applicationNamespace, PrivilegeGroup privilegeGroup, Privilege privilege) {
        return applicationNamespace + "." + privilegeGroup.getName() + "." + privilege.getName();
    }
}

