/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.localize;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.teamapps.ux.i18n.UTF8Control;

public interface ResourceBundleInfo {
    public static ResourceBundleInfo create(String baseName, Locale ... translations) {
        return ResourceBundleInfo.create(baseName, "properties", translations);
    }

    public static ResourceBundleInfo create(String baseName, String resourceFileSuffix, Locale ... translations) {
        Function<Locale, ResourceBundle> resourceBundleByLocaleFunction = locale -> ResourceBundle.getBundle(baseName, locale, (ResourceBundle.Control)new UTF8Control(resourceFileSuffix));
        return ResourceBundleInfo.create(resourceBundleByLocaleFunction, translations);
    }

    public static ResourceBundleInfo create(final Function<Locale, ResourceBundle> resourceBundleByLocaleFunction, final Locale ... translations) {
        return new ResourceBundleInfo(){

            @Override
            public Function<Locale, ResourceBundle> getResourceBundleByLocaleFunction() {
                return resourceBundleByLocaleFunction;
            }

            @Override
            public List<Locale> getTranslations() {
                return Arrays.asList(translations);
            }
        };
    }

    public Function<Locale, ResourceBundle> getResourceBundleByLocaleFunction();

    public List<Locale> getTranslations();
}

