/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.config;

import java.time.ZoneId;
import java.util.Locale;
import org.teamapps.config.ClientConfigProvider;
import org.teamapps.config.LocaleProvider;
import org.teamapps.config.ThemeProvider;
import org.teamapps.config.TimeZoneProvider;
import org.teamapps.theme.Theme;
import org.teamapps.theme.background.Background;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.ux.session.StylingTheme;

public class StandardClientConfigProvider<USER>
implements ClientConfigProvider<USER> {
    private LocaleProvider<USER> localeProvider;
    private TimeZoneProvider<USER> timeZoneProvider;
    private ThemeProvider<USER> themeProvider;
    private Theme defaultTheme = Theme.create(Background.createDefaultBackground(), false);

    public StandardClientConfigProvider() {
    }

    public StandardClientConfigProvider(LocaleProvider<USER> localeProvider, TimeZoneProvider<USER> timeZoneProvider, ThemeProvider<USER> themeProvider) {
        this.localeProvider = localeProvider;
        this.timeZoneProvider = timeZoneProvider;
        this.themeProvider = themeProvider;
    }

    @Override
    public void setUserTheme(USER user, Theme theme) {
        SessionContext context = CurrentSessionContext.get();
        StylingTheme stylingTheme = context.getConfiguration().getTheme();
        if (theme.isDarkTheme() && stylingTheme != StylingTheme.DARK || !theme.isDarkTheme() && stylingTheme == StylingTheme.DARK) {
            this.updateUserThemeConfiguration(user, theme);
        }
        theme.getBackground().registerAndApply(context);
    }

    private void updateUserThemeConfiguration(USER user, Theme theme) {
        SessionContext context = CurrentSessionContext.get();
        Locale userAgentLocale = Locale.forLanguageTag(context.getClientInfo().getPreferredLanguageIso());
        ZoneId userAgentTimeZone = ZoneId.of(context.getClientInfo().getTimeZone());
        Locale locale = this.getUserLocale(user, userAgentLocale);
        ZoneId timeZone = this.getUserTimeZone(user, userAgentTimeZone);
        this.setClientSessionConfiguration(locale, timeZone, theme);
    }

    @Override
    public void updateClientConfiguration(USER user) {
        SessionContext context = CurrentSessionContext.get();
        Locale userAgentLocale = Locale.forLanguageTag(context.getClientInfo().getPreferredLanguageIso());
        ZoneId userAgentTimeZone = ZoneId.of(context.getClientInfo().getTimeZone());
        Locale locale = this.getUserLocale(user, userAgentLocale);
        ZoneId timeZone = this.getUserTimeZone(user, userAgentTimeZone);
        Theme theme = this.getUserTheme(user);
        this.setClientSessionConfiguration(locale, timeZone, theme);
    }

    @Override
    public void setClientSessionConfiguration(Locale locale, ZoneId timeZone, Theme theme) {
        SessionContext context = CurrentSessionContext.get();
        boolean darkTheme = false;
        if (theme != null) {
            darkTheme = theme.isDarkTheme();
        }
        boolean optimizedForTouch = false;
        StylingTheme stylingTheme = StylingTheme.DEFAULT;
        if (context.getClientInfo().isMobileDevice()) {
            optimizedForTouch = true;
            stylingTheme = StylingTheme.MODERN;
        }
        if (darkTheme) {
            stylingTheme = StylingTheme.DARK;
        }
        context.setConfiguration(SessionConfiguration.create((Locale)locale, (ZoneId)timeZone, (StylingTheme)stylingTheme, (boolean)optimizedForTouch));
    }

    public void setDefaultTheme(Theme defaultTheme) {
        this.defaultTheme = defaultTheme;
    }

    @Override
    public Locale getUserLocale(USER user, Locale userAgentLocale) {
        return this.localeProvider != null ? this.localeProvider.getUserLocale(user, userAgentLocale) : userAgentLocale;
    }

    @Override
    public Theme getUserTheme(USER user) {
        return this.themeProvider != null ? this.themeProvider.getUserTheme(user) : this.defaultTheme;
    }

    @Override
    public ZoneId getUserTimeZone(USER user, ZoneId userAgentTimeZone) {
        return this.timeZoneProvider != null ? this.timeZoneProvider.getUserTimeZone(user, userAgentTimeZone) : userAgentTimeZone;
    }

    @Override
    public void setLocaleProvider(LocaleProvider<USER> localeProvider) {
        this.localeProvider = localeProvider;
    }

    @Override
    public void setTimeZoneProvider(TimeZoneProvider<USER> timeZoneProvider) {
        this.timeZoneProvider = timeZoneProvider;
    }

    @Override
    public void setThemeProvider(ThemeProvider<USER> themeProvider) {
        this.themeProvider = themeProvider;
    }
}

