/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.theme.background;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.teamapps.common.format.Color;
import org.teamapps.theme.background.BlurImage;
import org.teamapps.ux.session.SessionContext;

public class Background {
    private Color backgroundColor;
    private String backgroundImagePath;
    private String blurredBackgroundImagePath;
    private File backgroundImageFile;
    private File blurredBackgroundImageFile;
    private int animationDuration;
    private boolean blurred;
    private String uuid = UUID.randomUUID().toString();

    public static Background createDefaultBackground() {
        return Background.createImageBackground("/resources/backgrounds/default-bl.jpg", 0);
    }

    public static Background createDefaultLoginBackground() {
        return Background.createImageBackground("/resources/backgrounds/login3.jpg", "/resources/backgrounds/login3-bl.jpg", 0);
    }

    public static Background createColorBackground(Color color, int animationDuration) {
        return new Background(color, null, null, null, null, animationDuration);
    }

    public static Background createImageBackground(String backgroundImagePath, int animationDuration) {
        return new Background(null, backgroundImagePath, null, null, null, animationDuration);
    }

    public static Background createImageBackground(String backgroundImagePath, String blurredBackgroundImagePath, int animationDuration) {
        return new Background(null, backgroundImagePath, blurredBackgroundImagePath, null, null, animationDuration);
    }

    public static Background createImageBackground(File backgroundImageFile, int animationDuration) {
        return new Background(null, null, null, backgroundImageFile, null, animationDuration);
    }

    public static Background createImageBackground(File backgroundImageFile, File blurredBackgroundImageFile, int animationDuration) {
        return new Background(null, null, null, backgroundImageFile, blurredBackgroundImageFile, animationDuration);
    }

    public static Background createImageBackgroundWithBlurred(File backgroundImageFile, int animationDuration) throws IOException {
        BlurImage blurImage = new BlurImage();
        File blurredBackgroundImageFile = File.createTempFile("temp", ".png");
        blurImage.createBlurredImage(backgroundImageFile, blurredBackgroundImageFile);
        return new Background(null, null, null, backgroundImageFile, blurredBackgroundImageFile, animationDuration);
    }

    private Background(Color backgroundColor, String backgroundImagePath, String blurredBackgroundImagePath, File backgroundImageFile, File blurredBackgroundImageFile, int animationDuration) {
        this.backgroundColor = backgroundColor;
        this.backgroundImagePath = backgroundImagePath;
        this.blurredBackgroundImagePath = blurredBackgroundImagePath;
        this.backgroundImageFile = backgroundImageFile;
        this.blurredBackgroundImageFile = blurredBackgroundImageFile;
        this.animationDuration = animationDuration;
        if (blurredBackgroundImagePath != null || blurredBackgroundImageFile != null) {
            this.blurred = true;
        }
    }

    public void registerAndApply(SessionContext context) {
        this.registerBackground(context);
        this.applyBackground(context);
    }

    public void registerBackground(SessionContext context) {
        if (this.backgroundImagePath != null) {
            if (this.blurred) {
                context.registerBackgroundImage(this.uuid, this.backgroundImagePath, this.blurredBackgroundImagePath);
            } else {
                context.registerBackgroundImage(this.uuid, this.backgroundImagePath, this.backgroundImagePath);
            }
        } else if (this.backgroundImageFile != null) {
            if (this.blurred) {
                String imageLink = context.createFileLink(this.backgroundImageFile);
                String blurredImageLink = context.createFileLink(this.blurredBackgroundImageFile);
                context.registerBackgroundImage(this.uuid, imageLink, blurredImageLink);
            } else {
                String imageLink = context.createFileLink(this.backgroundImageFile);
                context.registerBackgroundImage(this.uuid, imageLink, imageLink);
            }
        }
    }

    public void applyBackground(SessionContext context) {
        if (this.backgroundColor != null) {
            context.setBackgroundImage(null, 0);
            context.setBackgroundColor(this.backgroundColor, this.animationDuration);
        } else if (this.backgroundImagePath != null) {
            context.setBackgroundImage(this.uuid, this.animationDuration);
        } else if (this.backgroundImageFile != null) {
            context.setBackgroundImage(this.uuid, this.animationDuration);
        }
    }
}

