/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.privilege;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teamapps.icons.api.Icon;
import org.teamapps.privilege.Privilege;

public class PrivilegeGroup {
    private final String name;
    private Icon icon;
    private String caption;
    private String description;
    private final List<Privilege> privileges = new ArrayList<Privilege>();

    public PrivilegeGroup(String name) {
        this.name = name;
    }

    public PrivilegeGroup(String name, Privilege ... privileges) {
        this.name = name;
        this.addPrivileges(privileges);
    }

    public PrivilegeGroup addPrivilege(Privilege privilege) {
        this.privileges.add(privilege);
        return this;
    }

    public PrivilegeGroup addPrivileges(Privilege ... privileges) {
        this.privileges.addAll(Arrays.asList(privileges));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public PrivilegeGroup setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public PrivilegeGroup setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public PrivilegeGroup setDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Privilege> getPrivileges() {
        return this.privileges;
    }
}

