/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.geoip;

import com.maxmind.db.Reader;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.Location;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.geoip.GeoIpInfo;
import org.teamapps.ux.session.ClientGeoIpInfo;

public class GeoIpLookupService {
    private static Logger logger = LoggerFactory.getLogger(GeoIpLookupService.class);
    private final String geoIpDatabasePath;
    private DatabaseReader databaseReader;
    private Map<String, CityResponse> resultCache;

    public GeoIpLookupService(String geoIpDatabasePath) throws IOException {
        this.geoIpDatabasePath = geoIpDatabasePath;
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(new File(geoIpDatabasePath)));
        this.databaseReader = new DatabaseReader.Builder((InputStream)inputStream).fileMode(Reader.FileMode.MEMORY).build();
        this.resultCache = new LinkedHashMap<String, CityResponse>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, CityResponse> eldest) {
                return this.size() > 7500;
            }
        };
    }

    public ClientGeoIpInfo getClientGeoIpInfo(String ip) {
        GeoIpInfo ipInfo = this.getGeoIpInfo(ip);
        return new ClientGeoIpInfo(ipInfo.getCountryIso(), ipInfo.getCountry(), ipInfo.getCity(), ipInfo.getLatitude(), ipInfo.getLongitude());
    }

    public GeoIpInfo getGeoIpInfo(String ip) {
        Location location;
        GeoIpInfo info = new GeoIpInfo(ip);
        CityResponse response = this.readIpEntry(ip);
        if (response == null) {
            return info;
        }
        if (response.getCountry() != null) {
            String iso = response.getCountry().getIsoCode();
            String country = response.getCountry().getName();
            info.setCountry(country);
            info.setCountryIso(iso);
        }
        if (response.getCity() != null) {
            info.setCity(response.getCity().getName());
        }
        if ((location = response.getLocation()) != null) {
            info.setLatitude(location.getLatitude().floatValue());
            info.setLongitude(location.getLongitude().floatValue());
        }
        return info;
    }

    private CityResponse readIpEntry(String ip) {
        if (ip == null) {
            return null;
        }
        CityResponse result = this.resultCache.get(ip);
        if (result == null) {
            try {
                CityResponse response = this.databaseReader.city(InetAddress.getByName(ip));
                this.resultCache.put(ip, response);
                return response;
            }
            catch (Exception e) {
                logger.warn("GEO-IP-ERROR:" + ip);
            }
        }
        return result;
    }
}

