package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ApplicationFolder extends Entity<ApplicationFolder> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_NAME = "name";
	final static String FIELD_APPLICATION = "application";
	final static String FIELD_APPLICATION_FOLDER_TYPE = "applicationFolderType";
	final static String FIELD_PARENT = "parent";
	final static String FIELD_CHILDREN = "children";
	final static String FIELD_MESSAGES = "messages";

    static ApplicationFolder create() {
        return new UdbApplicationFolder();
    }

    static ApplicationFolder create(int id) {
        return new UdbApplicationFolder(id, true);
    }

    static ApplicationFolder getById(int id) {
        return new UdbApplicationFolder(id, false);
    }

    static EntityBuilder<ApplicationFolder> getBuilder() {
        return new UdbApplicationFolder(0, false);
    }

    Instant getMetaCreationDate();

    ApplicationFolder setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ApplicationFolder setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ApplicationFolder setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ApplicationFolder setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ApplicationFolder setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ApplicationFolder setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ApplicationFolder setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ApplicationFolder setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ApplicationFolder setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ApplicationFolder setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ApplicationFolder setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ApplicationFolder setMetaDeletedBy(int value);

    String getName();

    ApplicationFolder setName(String value);

    Application getApplication();

    ApplicationFolder setApplication(Application value);

    ApplicationFolderType getApplicationFolderType();

    ApplicationFolder setApplicationFolderType(ApplicationFolderType value);

    ApplicationFolder getParent();

    ApplicationFolder setParent(ApplicationFolder value);

    List<ApplicationFolder> getChildren();

    ApplicationFolder setChildren(List<ApplicationFolder> value);

    int getChildrenCount();

    ApplicationFolder setChildren(ApplicationFolder ... value);

    BitSet getChildrenAsBitSet();

    ApplicationFolder addChildren(List<ApplicationFolder> value);

    ApplicationFolder addChildren(ApplicationFolder ... value);

    ApplicationFolder removeChildren(List<ApplicationFolder> value);

    ApplicationFolder removeChildren(ApplicationFolder ... value);

    ApplicationFolder removeAllChildren();

    List<Message> getMessages();

    ApplicationFolder setMessages(List<Message> value);

    int getMessagesCount();

    ApplicationFolder setMessages(Message ... value);

    BitSet getMessagesAsBitSet();

    ApplicationFolder addMessages(List<Message> value);

    ApplicationFolder addMessages(Message ... value);

    ApplicationFolder removeMessages(List<Message> value);

    ApplicationFolder removeMessages(Message ... value);

    ApplicationFolder removeAllMessages();


    static List<ApplicationFolder> getAll() {
        return UdbApplicationFolder.getAll();
    }

    static List<ApplicationFolder> sort(List<ApplicationFolder> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbApplicationFolder.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbApplicationFolder.getCount();
    }

    static ApplicationFolderQuery filter() {
        return new UdbApplicationFolderQuery();
    }
}

