package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.record.*;
import org.teamapps.universaldb.index.file.FileValue;
import org.teamapps.universaldb.index.translation.*;
import java.util.*;
import java.time.*;
import java.io.*;
import java.util.function.Supplier;


public interface ApplicationPerspective extends Entity<ApplicationPerspective> {

	final static String FIELD_META_CREATION_DATE = "metaCreationDate";
	final static String FIELD_META_CREATED_BY = "metaCreatedBy";
	final static String FIELD_META_MODIFICATION_DATE = "metaModificationDate";
	final static String FIELD_META_MODIFIED_BY = "metaModifiedBy";
	final static String FIELD_META_DELETION_DATE = "metaDeletionDate";
	final static String FIELD_META_DELETED_BY = "metaDeletedBy";
	final static String FIELD_APPLICATION = "application";
	final static String FIELD_NAME = "name";
	final static String FIELD_ICON = "icon";
	final static String FIELD_TITLE_KEY = "titleKey";
	final static String FIELD_DESCRIPTION_KEY = "descriptionKey";
	final static String FIELD_AUTO_PROVISION = "autoProvision";
	final static String FIELD_MANAGED_PERSPECTIVES = "managedPerspectives";

    static ApplicationPerspective create() {
        return new UdbApplicationPerspective();
    }

    static ApplicationPerspective create(int id) {
        return new UdbApplicationPerspective(id, true);
    }

    static ApplicationPerspective getById(int id) {
        return new UdbApplicationPerspective(id, false);
    }

    static EntityBuilder<ApplicationPerspective> getBuilder() {
        return new UdbApplicationPerspective(0, false);
    }

    Instant getMetaCreationDate();

    ApplicationPerspective setMetaCreationDate(Instant value);

    int getMetaCreationDateAsEpochSecond();

    ApplicationPerspective setMetaCreationDateAsEpochSecond(int value);

    long getMetaCreationDateAsEpochMilli();

    ApplicationPerspective setMetaCreationDateAsEpochMilli(long value);

    int getMetaCreatedBy();

    ApplicationPerspective setMetaCreatedBy(int value);

    Instant getMetaModificationDate();

    ApplicationPerspective setMetaModificationDate(Instant value);

    int getMetaModificationDateAsEpochSecond();

    ApplicationPerspective setMetaModificationDateAsEpochSecond(int value);

    long getMetaModificationDateAsEpochMilli();

    ApplicationPerspective setMetaModificationDateAsEpochMilli(long value);

    int getMetaModifiedBy();

    ApplicationPerspective setMetaModifiedBy(int value);

    Instant getMetaDeletionDate();

    ApplicationPerspective setMetaDeletionDate(Instant value);

    int getMetaDeletionDateAsEpochSecond();

    ApplicationPerspective setMetaDeletionDateAsEpochSecond(int value);

    long getMetaDeletionDateAsEpochMilli();

    ApplicationPerspective setMetaDeletionDateAsEpochMilli(long value);

    int getMetaDeletedBy();

    ApplicationPerspective setMetaDeletedBy(int value);

    Application getApplication();

    ApplicationPerspective setApplication(Application value);

    String getName();

    ApplicationPerspective setName(String value);

    String getIcon();

    ApplicationPerspective setIcon(String value);

    String getTitleKey();

    ApplicationPerspective setTitleKey(String value);

    String getDescriptionKey();

    ApplicationPerspective setDescriptionKey(String value);

    boolean getAutoProvision();

    ApplicationPerspective setAutoProvision(boolean value);

    List<ManagedApplicationPerspective> getManagedPerspectives();

    ApplicationPerspective setManagedPerspectives(List<ManagedApplicationPerspective> value);

    int getManagedPerspectivesCount();

    ApplicationPerspective setManagedPerspectives(ManagedApplicationPerspective ... value);

    BitSet getManagedPerspectivesAsBitSet();

    ApplicationPerspective addManagedPerspectives(List<ManagedApplicationPerspective> value);

    ApplicationPerspective addManagedPerspectives(ManagedApplicationPerspective ... value);

    ApplicationPerspective removeManagedPerspectives(List<ManagedApplicationPerspective> value);

    ApplicationPerspective removeManagedPerspectives(ManagedApplicationPerspective ... value);

    ApplicationPerspective removeAllManagedPerspectives();


    static List<ApplicationPerspective> getAll() {
        return UdbApplicationPerspective.getAll();
    }

    static List<ApplicationPerspective> sort(List<ApplicationPerspective> list, String sortFieldName, boolean ascending, String ... path) {
        return UdbApplicationPerspective.sort(list, sortFieldName, ascending, path);
    }

    static int getCount() {
        return UdbApplicationPerspective.getCount();
    }

    static ApplicationPerspectiveQuery filter() {
        return new UdbApplicationPerspectiveQuery();
    }
}

