package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbApplicationPerspective extends AbstractUdbEntity<ApplicationPerspective> implements ApplicationPerspective {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static SingleReferenceIndex application;
	protected static TextIndex name;
	protected static TextIndex icon;
	protected static TextIndex titleKey;
	protected static TextIndex descriptionKey;
	protected static BooleanIndex autoProvision;
	protected static MultiReferenceIndex managedPerspectives;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		application = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_APPLICATION);
		name = (TextIndex) tableIndex.getColumnIndex(FIELD_NAME);
		icon = (TextIndex) tableIndex.getColumnIndex(FIELD_ICON);
		titleKey = (TextIndex) tableIndex.getColumnIndex(FIELD_TITLE_KEY);
		descriptionKey = (TextIndex) tableIndex.getColumnIndex(FIELD_DESCRIPTION_KEY);
		autoProvision = (BooleanIndex) tableIndex.getColumnIndex(FIELD_AUTO_PROVISION);
		managedPerspectives = (MultiReferenceIndex) tableIndex.getColumnIndex(FIELD_MANAGED_PERSPECTIVES);
    }

    public static List<ApplicationPerspective> getAll() {
        return new EntityBitSetList<>(ApplicationPerspective.getBuilder(), table.getRecordBitSet());
    }

    public static List<ApplicationPerspective> sort(List<ApplicationPerspective> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<ApplicationPerspective> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, ApplicationPerspective.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbApplicationPerspective() {
        super(table);
    }

    public UdbApplicationPerspective(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public ApplicationPerspective build() {
        return new UdbApplicationPerspective();
    }

    @Override
    public ApplicationPerspective build(int id) {
        return new UdbApplicationPerspective(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public ApplicationPerspective setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public ApplicationPerspective setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public ApplicationPerspective setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public ApplicationPerspective setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public ApplicationPerspective setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public ApplicationPerspective setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public ApplicationPerspective setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public ApplicationPerspective setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public ApplicationPerspective setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public ApplicationPerspective setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public ApplicationPerspective setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public ApplicationPerspective setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public Application getApplication() {
		if (isChanged(application)) {
			return (Application) getReferenceChangeValue(application);
		} else {
			int id = application.getValue(getId());
			if (id > 0) {
				return Application.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public ApplicationPerspective setApplication(Application value) {
		setSingleReferenceValue(application, value, table);
		return this;
	}

	@Override
	public String getName() {
        return getTextValue(name);
	}

	@Override
	public ApplicationPerspective setName(String value) {
	    setTextValue(value, this.name);
		return this;
	}

	@Override
	public String getIcon() {
        return getTextValue(icon);
	}

	@Override
	public ApplicationPerspective setIcon(String value) {
	    setTextValue(value, this.icon);
		return this;
	}

	@Override
	public String getTitleKey() {
        return getTextValue(titleKey);
	}

	@Override
	public ApplicationPerspective setTitleKey(String value) {
	    setTextValue(value, this.titleKey);
		return this;
	}

	@Override
	public String getDescriptionKey() {
        return getTextValue(descriptionKey);
	}

	@Override
	public ApplicationPerspective setDescriptionKey(String value) {
	    setTextValue(value, this.descriptionKey);
		return this;
	}

	@Override
	public boolean getAutoProvision() {
	    return getBooleanValue(autoProvision);
	}

	@Override
	public ApplicationPerspective setAutoProvision(boolean value) {
	    setBooleanValue(value, this.autoProvision);
		return this;
	}

	@Override
	public List<ManagedApplicationPerspective> getManagedPerspectives() {
	    return getMultiReferenceValue(managedPerspectives, ManagedApplicationPerspective.getBuilder());
	}

	@Override
	public ApplicationPerspective setManagedPerspectives(List<ManagedApplicationPerspective> value) {
		setMultiReferenceValue(value, managedPerspectives);
		return this;
	}

	@Override
	public int getManagedPerspectivesCount() {
	    return getMultiReferenceValueCount(managedPerspectives, ManagedApplicationPerspective.getBuilder());
	}

	@Override
	public ApplicationPerspective setManagedPerspectives(ManagedApplicationPerspective ... value) {
		setMultiReferenceValue(Arrays.asList(value), managedPerspectives);
		return this;
	}

	@Override
	public BitSet getManagedPerspectivesAsBitSet() {
	    return getMultiReferenceValueAsBitSet(managedPerspectives, ManagedApplicationPerspective.getBuilder());
	}

	@Override
	public ApplicationPerspective addManagedPerspectives(List<ManagedApplicationPerspective> value) {
		addMultiReferenceValue(value, managedPerspectives);
		return this;
	}

	@Override
	public ApplicationPerspective addManagedPerspectives(ManagedApplicationPerspective ... value) {
		addMultiReferenceValue(Arrays.asList(value), managedPerspectives);
		return this;
	}

	@Override
	public ApplicationPerspective removeManagedPerspectives(List<ManagedApplicationPerspective> value) {
		removeMultiReferenceValue(value, managedPerspectives);
		return this;
	}

	@Override
	public ApplicationPerspective removeManagedPerspectives(ManagedApplicationPerspective ... value) {
		removeMultiReferenceValue(Arrays.asList(value), managedPerspectives);
		return this;
	}

	@Override
	public ApplicationPerspective removeAllManagedPerspectives() {
		removeAllMultiReferenceValue(managedPerspectives);
		return this;
	}


    @Override
    public UdbApplicationPerspective save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbApplicationPerspective saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbApplicationPerspective save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



