package org.teamapps.model.controlcenter;

import org.teamapps.universaldb.*;
import org.teamapps.universaldb.index.*;
import org.teamapps.universaldb.index.numeric.*;
import org.teamapps.universaldb.index.text.*;
import org.teamapps.universaldb.index.translation.*;
import org.teamapps.universaldb.index.bool.*;
import org.teamapps.universaldb.index.file.*;
import org.teamapps.universaldb.index.reference.multi.*;
import org.teamapps.universaldb.index.reference.single.*;
import org.teamapps.universaldb.index.binary.*;
import org.teamapps.universaldb.pojo.*;
import org.teamapps.universaldb.pojo.template.*;
import org.teamapps.universaldb.transaction.*;
import org.teamapps.universaldb.record.*;

import java.util.*;
import java.time.*;
import java.io.*;
import java.util.concurrent.*;
import java.util.function.Supplier;


public class UdbUserRoleAssignment extends AbstractUdbEntity<UserRoleAssignment> implements UserRoleAssignment {
	protected static TableIndex table;
	protected static IntegerIndex metaCreationDate;
	protected static IntegerIndex metaCreatedBy;
	protected static IntegerIndex metaModificationDate;
	protected static IntegerIndex metaModifiedBy;
	protected static IntegerIndex metaDeletionDate;
	protected static IntegerIndex metaDeletedBy;
	protected static SingleReferenceIndex user;
	protected static SingleReferenceIndex role;
	protected static SingleReferenceIndex organizationUnit;
	protected static IntegerIndex lastVerified;
	protected static SingleReferenceIndex lastVerifiedBy;

    private static void setTableIndex(TableIndex tableIndex) {
        table = tableIndex;
		metaCreationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATION_DATE);
		metaCreatedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_CREATED_BY);
		metaModificationDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFICATION_DATE);
		metaModifiedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_MODIFIED_BY);
		metaDeletionDate = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETION_DATE);
		metaDeletedBy = (IntegerIndex) tableIndex.getColumnIndex(FIELD_META_DELETED_BY);
		user = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_USER);
		role = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ROLE);
		organizationUnit = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_ORGANIZATION_UNIT);
		lastVerified = (IntegerIndex) tableIndex.getColumnIndex(FIELD_LAST_VERIFIED);
		lastVerifiedBy = (SingleReferenceIndex) tableIndex.getColumnIndex(FIELD_LAST_VERIFIED_BY);
    }

    public static List<UserRoleAssignment> getAll() {
        return new EntityBitSetList<>(UserRoleAssignment.getBuilder(), table.getRecordBitSet());
    }

    public static List<UserRoleAssignment> sort(List<UserRoleAssignment> list, String sortFieldName, boolean ascending, String ... path) {
    	return sort(table, list, sortFieldName, ascending, path);
    }

    public static List<UserRoleAssignment> sort(BitSet recordIds, String sortFieldName, boolean ascending, String ... path) {
        return sort(table, UserRoleAssignment.getBuilder(), recordIds, sortFieldName, ascending, path);
    }

    public static int getCount() {
        return table.getCount();
    }

    public UdbUserRoleAssignment() {
        super(table);
    }

    public UdbUserRoleAssignment(int id, boolean createEntity) {
        super(table, id, createEntity);
    }

    @Override
    public UserRoleAssignment build() {
        return new UdbUserRoleAssignment();
    }

    @Override
    public UserRoleAssignment build(int id) {
        return new UdbUserRoleAssignment(id, false);
    }

	@Override
	public Instant getMetaCreationDate() {
	    return getTimestampValue(metaCreationDate);
	}

	@Override
	public UserRoleAssignment setMetaCreationDate(Instant value) {
	    setTimestampValue(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaCreationDate);
	}

	@Override
	public UserRoleAssignment setMetaCreationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaCreationDate);
		return this;
	}

	@Override
	public long getMetaCreationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaCreationDate);
	}

	@Override
	public UserRoleAssignment setMetaCreationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaCreationDate);
		return this;
	}

	@Override
	public int getMetaCreatedBy() {
        return getIntValue(metaCreatedBy);
	}

	@Override
	public UserRoleAssignment setMetaCreatedBy(int value) {
	    setIntValue(value, this.metaCreatedBy);
		return this;
	}

	@Override
	public Instant getMetaModificationDate() {
	    return getTimestampValue(metaModificationDate);
	}

	@Override
	public UserRoleAssignment setMetaModificationDate(Instant value) {
	    setTimestampValue(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModificationDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaModificationDate);
	}

	@Override
	public UserRoleAssignment setMetaModificationDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaModificationDate);
		return this;
	}

	@Override
	public long getMetaModificationDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaModificationDate);
	}

	@Override
	public UserRoleAssignment setMetaModificationDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaModificationDate);
		return this;
	}

	@Override
	public int getMetaModifiedBy() {
        return getIntValue(metaModifiedBy);
	}

	@Override
	public UserRoleAssignment setMetaModifiedBy(int value) {
	    setIntValue(value, this.metaModifiedBy);
		return this;
	}

	@Override
	public Instant getMetaDeletionDate() {
	    return getTimestampValue(metaDeletionDate);
	}

	@Override
	public UserRoleAssignment setMetaDeletionDate(Instant value) {
	    setTimestampValue(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletionDateAsEpochSecond() {
	    return getTimestampAsEpochSecond(metaDeletionDate);
	}

	@Override
	public UserRoleAssignment setMetaDeletionDateAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public long getMetaDeletionDateAsEpochMilli() {
	    return getTimestampAsEpochMilli(metaDeletionDate);
	}

	@Override
	public UserRoleAssignment setMetaDeletionDateAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.metaDeletionDate);
		return this;
	}

	@Override
	public int getMetaDeletedBy() {
        return getIntValue(metaDeletedBy);
	}

	@Override
	public UserRoleAssignment setMetaDeletedBy(int value) {
	    setIntValue(value, this.metaDeletedBy);
		return this;
	}

	@Override
	public User getUser() {
		if (isChanged(user)) {
			return (User) getReferenceChangeValue(user);
		} else {
			int id = user.getValue(getId());
			if (id > 0) {
				return User.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public UserRoleAssignment setUser(User value) {
		setSingleReferenceValue(user, value, table);
		return this;
	}

	@Override
	public Role getRole() {
		if (isChanged(role)) {
			return (Role) getReferenceChangeValue(role);
		} else {
			int id = role.getValue(getId());
			if (id > 0) {
				return Role.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public UserRoleAssignment setRole(Role value) {
		setSingleReferenceValue(role, value, table);
		return this;
	}

	@Override
	public OrganizationUnit getOrganizationUnit() {
		if (isChanged(organizationUnit)) {
			return (OrganizationUnit) getReferenceChangeValue(organizationUnit);
		} else {
			int id = organizationUnit.getValue(getId());
			if (id > 0) {
				return OrganizationUnit.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public UserRoleAssignment setOrganizationUnit(OrganizationUnit value) {
		setSingleReferenceValue(organizationUnit, value, table);
		return this;
	}

	@Override
	public Instant getLastVerified() {
	    return getTimestampValue(lastVerified);
	}

	@Override
	public UserRoleAssignment setLastVerified(Instant value) {
	    setTimestampValue(value, this.lastVerified);
		return this;
	}

	@Override
	public int getLastVerifiedAsEpochSecond() {
	    return getTimestampAsEpochSecond(lastVerified);
	}

	@Override
	public UserRoleAssignment setLastVerifiedAsEpochSecond(int value) {
	    setTimestampAsEpochSecond(value, this.lastVerified);
		return this;
	}

	@Override
	public long getLastVerifiedAsEpochMilli() {
	    return getTimestampAsEpochMilli(lastVerified);
	}

	@Override
	public UserRoleAssignment setLastVerifiedAsEpochMilli(long value) {
	    setTimestampAsEpochMilli(value, this.lastVerified);
		return this;
	}

	@Override
	public User getLastVerifiedBy() {
		if (isChanged(lastVerifiedBy)) {
			return (User) getReferenceChangeValue(lastVerifiedBy);
		} else {
			int id = lastVerifiedBy.getValue(getId());
			if (id > 0) {
				return User.getById(id);
			} else {
				return null;
			}
		}
	}

	@Override
	public UserRoleAssignment setLastVerifiedBy(User value) {
		setSingleReferenceValue(lastVerifiedBy, value, table);
		return this;
	}


    @Override
    public UdbUserRoleAssignment save(Transaction transaction, boolean strictChangeVerification) {
        save(transaction, table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbUserRoleAssignment saveTransactional(boolean strictChangeVerification) {
        save(UniversalDB.getThreadLocalTransaction(), table, strictChangeVerification);
        return this;
    }

    @Override
    public UdbUserRoleAssignment save() {
        save(table);
        return this;
    }

    @Override
    public void delete(Transaction transaction) {
        delete(transaction, table);
    }

    @Override
    public void delete() {
        delete(table);
    }

	@Override
	public String toString() {
    	StringBuilder sb = new StringBuilder();
    	sb.append(table.getName()).append(": ").append(getId()).append("\n");
		for (ColumnIndex column : table.getColumnIndices()) {
			sb.append("\t").append(column.getName()).append(": ").append(column.getStringValue(getId()));
			if (isChanged(column)) {
				TransactionRecordValue changeValue = getChangeValue(column);
				sb.append(" -> ").append(changeValue.getValue());
			}
			sb.append("\n");
		}
		return sb.toString();
	}
}



