/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.teamapps.application.api.application.ApplicationPerspectiveBuilder;
import org.teamapps.application.api.application.PerspectiveBuilder;
import org.teamapps.application.api.config.ApplicationConfig;
import org.teamapps.application.api.localization.LocalizationData;
import org.teamapps.application.api.privilege.ApplicationPrivilegeProvider;
import org.teamapps.application.api.privilege.ApplicationRole;
import org.teamapps.application.api.privilege.PrivilegeGroup;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.api.versioning.ApplicationVersion;
import org.teamapps.application.server.controlcenter.Privileges;
import org.teamapps.application.server.controlcenter.accesscontrol.AccessControlPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationGroupsPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationProvisioningPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationUpdatesPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applications.ApplicationsPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.applocal.AppLocalAdministrationPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.database.DataBasePerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationChartPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationFieldPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.organization.OrganizationUnitTypePerspectiveBuilder;
import org.teamapps.application.server.controlcenter.roles.RolesPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.roles.UserRoleAssignmentPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.systemlog.SystemLogPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.systenconfig.ApplicationConfigurationPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.translations.TranslationsPerspectiveBuilder;
import org.teamapps.application.server.controlcenter.users.UsersPerspectiveBuilder;
import org.teamapps.application.server.system.config.SystemConfig;
import org.teamapps.icons.Icon;
import org.teamapps.model.ControlCenterSchema;
import org.teamapps.universaldb.schema.SchemaInfoProvider;

public class ControlCenterAppBuilder
implements ApplicationPerspectiveBuilder {
    private ApplicationConfig<SystemConfig> applicationConfig;

    public ControlCenterAppBuilder() {
        SystemConfig config = new SystemConfig();
        this.applicationConfig = new ApplicationConfig();
        this.applicationConfig.setConfig((Object)config);
    }

    public List<PerspectiveBuilder> getPerspectiveBuilders() {
        return Arrays.asList(new PerspectiveBuilder[]{new UsersPerspectiveBuilder(), new OrganizationPerspectiveBuilder(), new RolesPerspectiveBuilder(), new AccessControlPerspectiveBuilder(), new ApplicationsPerspectiveBuilder(), new TranslationsPerspectiveBuilder(), new ApplicationConfigurationPerspectiveBuilder(), new SystemLogPerspectiveBuilder(), new DataBasePerspectiveBuilder(), new AppLocalAdministrationPerspectiveBuilder(), new ApplicationGroupsPerspectiveBuilder(), new ApplicationProvisioningPerspectiveBuilder(), new ApplicationUpdatesPerspectiveBuilder(), new OrganizationChartPerspectiveBuilder(), new OrganizationFieldPerspectiveBuilder(), new OrganizationUnitTypePerspectiveBuilder(), new UserRoleAssignmentPerspectiveBuilder()});
    }

    public ApplicationVersion getApplicationVersion() {
        return ApplicationVersion.create((int)0, (int)34);
    }

    public Icon getApplicationIcon() {
        return ApplicationIcons.WINDOW_KEY;
    }

    public String getApplicationName() {
        return "controlCenter";
    }

    public String getApplicationTitleKey() {
        return "application.title";
    }

    public String getApplicationDescriptionKey() {
        return "application.desc";
    }

    public List<ApplicationRole> getApplicationRoles() {
        return null;
    }

    public List<PrivilegeGroup> getPrivilegeGroups() {
        return Privileges.getPrivileges();
    }

    public LocalizationData getLocalizationData() {
        return LocalizationData.createFromPropertyFiles((String)"org.teamapps.application.server.i18n.controlCenter", (ClassLoader)this.getClass().getClassLoader(), (Locale[])new Locale[]{Locale.ENGLISH});
    }

    public SchemaInfoProvider getDatabaseModel() {
        return new ControlCenterSchema();
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public void bootstrapApplicationBuilder() {
    }

    public boolean isApplicationAccessible(ApplicationPrivilegeProvider privilegeProvider) {
        return privilegeProvider.isAllowed(Privileges.LAUNCH_APPLICATION);
    }
}

