/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.application.server.controlcenter.organization;

import org.teamapps.application.api.application.ApplicationInstanceData;
import org.teamapps.application.api.theme.ApplicationIcons;
import org.teamapps.application.server.system.application.AbstractManagedApplicationPerspective;
import org.teamapps.application.server.system.template.PropertyProviders;
import org.teamapps.application.server.ux.IconUtils;
import org.teamapps.application.server.ux.UiUtils;
import org.teamapps.application.server.ux.localize.TranslatableField;
import org.teamapps.application.server.ux.localize.TranslatableTextUtils;
import org.teamapps.application.tools.EntityModelBuilder;
import org.teamapps.common.format.Color;
import org.teamapps.databinding.MutableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.Icon;
import org.teamapps.model.controlcenter.OrganizationField;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;

public class OrganizationFieldPerspective
extends AbstractManagedApplicationPerspective {
    private final TwoWayBindableValue<OrganizationField> selectedField = TwoWayBindableValue.create();

    public OrganizationFieldPerspective(ApplicationInstanceData applicationInstanceData, MutableValue<String> perspectiveInfoBadgeValue) {
        super(applicationInstanceData, perspectiveInfoBadgeValue);
        this.createUi();
    }

    private void createUi() {
        View masterView = this.getPerspective().addView(View.createView((String)"center", (Icon)ApplicationIcons.ELEMENTS_TREE, (String)this.getLocalized("organizationField.organizationFields"), null));
        View detailView = this.getPerspective().addView(View.createView((String)"right", (Icon)ApplicationIcons.ELEMENTS_TREE, (String)this.getLocalized("organizationField.organizationField"), null));
        detailView.getPanel().setBodyBackgroundColor((Color)Color.WHITE.withAlpha(0.9f));
        EntityModelBuilder orgFieldModelBuilder = new EntityModelBuilder(OrganizationField::filter, this.getApplicationInstanceData());
        orgFieldModelBuilder.attachViewCountHandler(masterView, () -> this.getLocalized("organizationField.organizationFields"));
        orgFieldModelBuilder.attachSearchField(masterView);
        orgFieldModelBuilder.onSelectedRecordChanged.addListener(arg_0 -> this.selectedField.set(arg_0));
        Table table = orgFieldModelBuilder.createTemplateFieldTableList((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_SINGLE_LINE, PropertyProviders.createOrganizationFieldPropertyProvider(this.getApplicationInstanceData()), 38);
        orgFieldModelBuilder.updateModels();
        masterView.setComponent((Component)table);
        ToolbarButtonGroup buttonGroup = detailView.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        ToolbarButton addButton = buttonGroup.addButton(ToolbarButton.create((Icon)ApplicationIcons.ADD, (String)this.getLocalized("org.teamapps.dictionary.add"), (String)this.getLocalized("org.teamapps.dictionary.addRecord")));
        buttonGroup = detailView.addLocalButtonGroup(new ToolbarButtonGroup());
        ToolbarButton saveButton = buttonGroup.addButton(ToolbarButton.createSmall((Icon)ApplicationIcons.FLOPPY_DISK, (String)this.getLocalized("org.teamapps.dictionary.saveChanges")));
        TranslatableField translatableNameField = TranslatableTextUtils.createTranslatableField(this.getApplicationInstanceData());
        ComboBox iconComboBox = ApplicationIcons.createIconComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE, (boolean)true);
        iconComboBox.setDropDownTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        ResponsiveForm form = new ResponsiveForm(120, 120, 0);
        ResponsiveFormLayout formLayout = form.addResponsiveFormLayout(450);
        formLayout.addSection().setCollapsible(false).setDrawHeaderLine(false);
        formLayout.addLabelAndField(null, this.getLocalized("organizationField.organizationFieldName"), (AbstractField)translatableNameField);
        formLayout.addLabelAndField(null, this.getLocalized("organizationField.icon"), (AbstractField)iconComboBox);
        detailView.setComponent((Component)form);
        addButton.onClick.addListener(() -> this.selectedField.set((Object)OrganizationField.create()));
        saveButton.onClick.addListener(() -> {
            OrganizationField field = (OrganizationField)this.selectedField.get();
            if (field != null && translatableNameField.getValue() != null && iconComboBox.getValue() != null) {
                field.setTitle(translatableNameField.getValue()).setIcon(IconUtils.encodeNoStyle((Icon)iconComboBox.getValue())).save();
                UiUtils.showSaveNotification(true, this.getApplicationInstanceData());
                orgFieldModelBuilder.updateModels();
            } else {
                UiUtils.showSaveNotification(false, this.getApplicationInstanceData());
            }
        });
        this.selectedField.onChanged().addListener(type -> {
            translatableNameField.setValue(type.getTitle());
            iconComboBox.setValue(IconUtils.decodeIcon(type.getIcon()));
        });
        this.selectedField.set((Object)OrganizationField.create());
    }
}

